package zio.aws.pinpointemail.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpointemail.model.primitives.{DnsToken, Enabled}
import scala.jdk.CollectionConverters.*
final case class DkimAttributes(
    signingEnabled: Option[Enabled] = None,
    status: Option[zio.aws.pinpointemail.model.DkimStatus] = None,
    tokens: Option[Iterable[DnsToken]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpointemail.model.DkimAttributes = {
    import DkimAttributes.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpointemail.model.DkimAttributes
      .builder()
      .optionallyWith(
        signingEnabled.map(value => Enabled.unwrap(value): java.lang.Boolean)
      )(_.signingEnabled)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        tokens.map(value =>
          value.map { item =>
            DnsToken.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.tokens)
      .build()
  }
  def asReadOnly: zio.aws.pinpointemail.model.DkimAttributes.ReadOnly =
    zio.aws.pinpointemail.model.DkimAttributes.wrap(buildAwsValue())
}
object DkimAttributes {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpointemail.model.DkimAttributes
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpointemail.model.DkimAttributes =
      zio.aws.pinpointemail.model.DkimAttributes(
        signingEnabled.map(value => value),
        status.map(value => value),
        tokens.map(value => value)
      )
    def signingEnabled: Option[Enabled]
    def status: Option[zio.aws.pinpointemail.model.DkimStatus]
    def tokens: Option[List[DnsToken]]
    def getSigningEnabled: ZIO[Any, AwsError, Enabled] =
      AwsError.unwrapOptionField("signingEnabled", signingEnabled)
    def getStatus: ZIO[Any, AwsError, zio.aws.pinpointemail.model.DkimStatus] =
      AwsError.unwrapOptionField("status", status)
    def getTokens: ZIO[Any, AwsError, List[DnsToken]] =
      AwsError.unwrapOptionField("tokens", tokens)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpointemail.model.DkimAttributes
  ) extends zio.aws.pinpointemail.model.DkimAttributes.ReadOnly {
    override val signingEnabled: Option[Enabled] = scala
      .Option(impl.signingEnabled())
      .map(value => zio.aws.pinpointemail.model.primitives.Enabled(value))
    override val status: Option[zio.aws.pinpointemail.model.DkimStatus] = scala
      .Option(impl.status())
      .map(value => zio.aws.pinpointemail.model.DkimStatus.wrap(value))
    override val tokens: Option[List[DnsToken]] = scala
      .Option(impl.tokens())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.pinpointemail.model.primitives.DnsToken(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpointemail.model.DkimAttributes
  ): zio.aws.pinpointemail.model.DkimAttributes.ReadOnly = new Wrapper(impl)
}
