package zio.aws.pinpointemail.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.pinpointemail.model.primitives.{
  EventDestinationName,
  ConfigurationSetName
}
import scala.jdk.CollectionConverters.*
final case class DeleteConfigurationSetEventDestinationRequest(
    configurationSetName: ConfigurationSetName,
    eventDestinationName: EventDestinationName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpointemail.model.DeleteConfigurationSetEventDestinationRequest = {
    import DeleteConfigurationSetEventDestinationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpointemail.model.DeleteConfigurationSetEventDestinationRequest
      .builder()
      .configurationSetName(
        ConfigurationSetName.unwrap(configurationSetName): java.lang.String
      )
      .eventDestinationName(
        EventDestinationName.unwrap(eventDestinationName): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.pinpointemail.model.DeleteConfigurationSetEventDestinationRequest.ReadOnly =
    zio.aws.pinpointemail.model.DeleteConfigurationSetEventDestinationRequest
      .wrap(buildAwsValue())
}
object DeleteConfigurationSetEventDestinationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpointemail.model.DeleteConfigurationSetEventDestinationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.pinpointemail.model.DeleteConfigurationSetEventDestinationRequest =
      zio.aws.pinpointemail.model.DeleteConfigurationSetEventDestinationRequest(
        configurationSetName,
        eventDestinationName
      )
    def configurationSetName: ConfigurationSetName
    def eventDestinationName: EventDestinationName
    def getConfigurationSetName: ZIO[Any, Nothing, ConfigurationSetName] =
      ZIO.succeed(configurationSetName)
    def getEventDestinationName: ZIO[Any, Nothing, EventDestinationName] =
      ZIO.succeed(eventDestinationName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpointemail.model.DeleteConfigurationSetEventDestinationRequest
  ) extends zio.aws.pinpointemail.model.DeleteConfigurationSetEventDestinationRequest.ReadOnly {
    override val configurationSetName: ConfigurationSetName =
      zio.aws.pinpointemail.model.primitives
        .ConfigurationSetName(impl.configurationSetName())
    override val eventDestinationName: EventDestinationName =
      zio.aws.pinpointemail.model.primitives
        .EventDestinationName(impl.eventDestinationName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpointemail.model.DeleteConfigurationSetEventDestinationRequest
  ): zio.aws.pinpointemail.model.DeleteConfigurationSetEventDestinationRequest.ReadOnly =
    new Wrapper(impl)
}
