package zio.aws.pinpointemail
import zio.aws.pinpointemail.model.CreateConfigurationSetEventDestinationResponse.ReadOnly
import zio.aws.core.config.AwsConfig
import software.amazon.awssdk.services.pinpointemail.model.{
  DeleteDedicatedIpPoolRequest,
  GetDedicatedIpResponse,
  GetAccountResponse,
  PutAccountDedicatedIpWarmupAttributesResponse,
  DeleteConfigurationSetEventDestinationResponse,
  GetDeliverabilityDashboardOptionsResponse,
  DedicatedIp,
  ListDomainDeliverabilityCampaignsResponse,
  DeleteConfigurationSetResponse,
  SendEmailResponse,
  PutEmailIdentityFeedbackAttributesResponse,
  DeleteConfigurationSetRequest,
  PutDeliverabilityDashboardOptionRequest,
  ListConfigurationSetsResponse,
  GetDedicatedIpRequest,
  CreateConfigurationSetEventDestinationResponse,
  UpdateConfigurationSetEventDestinationRequest,
  GetDedicatedIpsResponse,
  CreateDeliverabilityTestReportRequest,
  DeliverabilityTestReport,
  GetDomainDeliverabilityCampaignRequest,
  DomainDeliverabilityCampaign,
  PutConfigurationSetSendingOptionsRequest,
  GetEmailIdentityRequest,
  PutAccountSendingAttributesRequest,
  PutEmailIdentityFeedbackAttributesRequest,
  GetDomainDeliverabilityCampaignResponse,
  PutDedicatedIpWarmupAttributesRequest,
  ListTagsForResourceRequest,
  IdentityInfo,
  GetEmailIdentityResponse,
  CreateConfigurationSetRequest,
  CreateEmailIdentityRequest,
  CreateConfigurationSetResponse,
  UpdateConfigurationSetEventDestinationResponse,
  PutAccountDedicatedIpWarmupAttributesRequest,
  CreateDedicatedIpPoolResponse,
  ListDedicatedIpPoolsResponse,
  GetConfigurationSetRequest,
  GetBlacklistReportsRequest,
  PutEmailIdentityDkimAttributesResponse,
  ListTagsForResourceResponse,
  GetDedicatedIpsRequest,
  UntagResourceResponse,
  ListEmailIdentitiesResponse,
  ListDedicatedIpPoolsRequest,
  ListEmailIdentitiesRequest,
  PutEmailIdentityDkimAttributesRequest,
  GetConfigurationSetEventDestinationsResponse,
  SendEmailRequest,
  PutConfigurationSetTrackingOptionsRequest,
  GetAccountRequest,
  PutConfigurationSetDeliveryOptionsRequest,
  ListConfigurationSetsRequest,
  GetConfigurationSetEventDestinationsRequest,
  ListDeliverabilityTestReportsRequest,
  GetDomainStatisticsReportRequest,
  CreateConfigurationSetEventDestinationRequest,
  PutDedicatedIpWarmupAttributesResponse,
  GetBlacklistReportsResponse,
  PutConfigurationSetDeliveryOptionsResponse,
  UntagResourceRequest,
  DeleteEmailIdentityResponse,
  PutDedicatedIpInPoolRequest,
  GetDeliverabilityDashboardOptionsRequest,
  PutConfigurationSetReputationOptionsRequest,
  CreateDeliverabilityTestReportResponse,
  PutDedicatedIpInPoolResponse,
  DeleteConfigurationSetEventDestinationRequest,
  CreateEmailIdentityResponse,
  PutAccountSendingAttributesResponse,
  GetConfigurationSetResponse,
  ListDomainDeliverabilityCampaignsRequest,
  CreateDedicatedIpPoolRequest,
  PutConfigurationSetSendingOptionsResponse,
  PutEmailIdentityMailFromAttributesResponse,
  PutConfigurationSetReputationOptionsResponse,
  GetDeliverabilityTestReportRequest,
  PutConfigurationSetTrackingOptionsResponse,
  ListDeliverabilityTestReportsResponse,
  DeleteDedicatedIpPoolResponse,
  PutEmailIdentityMailFromAttributesRequest,
  TagResourceResponse,
  PutDeliverabilityDashboardOptionResponse,
  GetDeliverabilityTestReportResponse,
  TagResourceRequest,
  GetDomainStatisticsReportResponse,
  DeleteEmailIdentityRequest
}
import zio.aws.pinpointemail.model.primitives.{ConfigurationSetName, PoolName}
import zio.aws.core.{AwsServiceBase, AwsError}
import software.amazon.awssdk.services.pinpointemail.{
  PinpointEmailAsyncClientBuilder,
  PinpointEmailAsyncClient
}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, ZManaged, IO, ZIO, ZLayer}
import zio.stream.ZStream
import scala.jdk.CollectionConverters.*
trait PinpointEmail extends AspectSupport[PinpointEmail] {
  val api: PinpointEmailAsyncClient
  def getConfigurationSet(
      request: zio.aws.pinpointemail.model.GetConfigurationSetRequest
  ): IO[
    AwsError,
    zio.aws.pinpointemail.model.GetConfigurationSetResponse.ReadOnly
  ]
  def getDomainDeliverabilityCampaign(
      request: zio.aws.pinpointemail.model.GetDomainDeliverabilityCampaignRequest
  ): IO[
    AwsError,
    zio.aws.pinpointemail.model.GetDomainDeliverabilityCampaignResponse.ReadOnly
  ]
  def createConfigurationSetEventDestination(
      request: zio.aws.pinpointemail.model.CreateConfigurationSetEventDestinationRequest
  ): IO[AwsError, ReadOnly]
  def putConfigurationSetReputationOptions(
      request: zio.aws.pinpointemail.model.PutConfigurationSetReputationOptionsRequest
  ): IO[
    AwsError,
    zio.aws.pinpointemail.model.PutConfigurationSetReputationOptionsResponse.ReadOnly
  ]
  def putAccountSendingAttributes(
      request: zio.aws.pinpointemail.model.PutAccountSendingAttributesRequest
  ): IO[
    AwsError,
    zio.aws.pinpointemail.model.PutAccountSendingAttributesResponse.ReadOnly
  ]
  def listEmailIdentities(
      request: zio.aws.pinpointemail.model.ListEmailIdentitiesRequest
  ): ZStream[Any, AwsError, zio.aws.pinpointemail.model.IdentityInfo.ReadOnly]
  def listEmailIdentitiesPaginated(
      request: zio.aws.pinpointemail.model.ListEmailIdentitiesRequest
  ): IO[
    AwsError,
    zio.aws.pinpointemail.model.ListEmailIdentitiesResponse.ReadOnly
  ]
  def createEmailIdentity(
      request: zio.aws.pinpointemail.model.CreateEmailIdentityRequest
  ): IO[
    AwsError,
    zio.aws.pinpointemail.model.CreateEmailIdentityResponse.ReadOnly
  ]
  def listDedicatedIpPools(
      request: zio.aws.pinpointemail.model.ListDedicatedIpPoolsRequest
  ): ZStream[Any, AwsError, PoolName]
  def listDedicatedIpPoolsPaginated(
      request: zio.aws.pinpointemail.model.ListDedicatedIpPoolsRequest
  ): IO[
    AwsError,
    zio.aws.pinpointemail.model.ListDedicatedIpPoolsResponse.ReadOnly
  ]
  def putAccountDedicatedIpWarmupAttributes(
      request: zio.aws.pinpointemail.model.PutAccountDedicatedIpWarmupAttributesRequest
  ): IO[
    AwsError,
    zio.aws.pinpointemail.model.PutAccountDedicatedIpWarmupAttributesResponse.ReadOnly
  ]
  def getConfigurationSetEventDestinations(
      request: zio.aws.pinpointemail.model.GetConfigurationSetEventDestinationsRequest
  ): IO[
    AwsError,
    zio.aws.pinpointemail.model.GetConfigurationSetEventDestinationsResponse.ReadOnly
  ]
  def sendEmail(
      request: zio.aws.pinpointemail.model.SendEmailRequest
  ): IO[AwsError, zio.aws.pinpointemail.model.SendEmailResponse.ReadOnly]
  def getEmailIdentity(
      request: zio.aws.pinpointemail.model.GetEmailIdentityRequest
  ): IO[AwsError, zio.aws.pinpointemail.model.GetEmailIdentityResponse.ReadOnly]
  def putConfigurationSetTrackingOptions(
      request: zio.aws.pinpointemail.model.PutConfigurationSetTrackingOptionsRequest
  ): IO[
    AwsError,
    zio.aws.pinpointemail.model.PutConfigurationSetTrackingOptionsResponse.ReadOnly
  ]
  def deleteEmailIdentity(
      request: zio.aws.pinpointemail.model.DeleteEmailIdentityRequest
  ): IO[
    AwsError,
    zio.aws.pinpointemail.model.DeleteEmailIdentityResponse.ReadOnly
  ]
  def getDeliverabilityDashboardOptions(
      request: zio.aws.pinpointemail.model.GetDeliverabilityDashboardOptionsRequest
  ): IO[
    AwsError,
    zio.aws.pinpointemail.model.GetDeliverabilityDashboardOptionsResponse.ReadOnly
  ]
  def getAccount(
      request: zio.aws.pinpointemail.model.GetAccountRequest
  ): IO[AwsError, zio.aws.pinpointemail.model.GetAccountResponse.ReadOnly]
  def getDomainStatisticsReport(
      request: zio.aws.pinpointemail.model.GetDomainStatisticsReportRequest
  ): IO[
    AwsError,
    zio.aws.pinpointemail.model.GetDomainStatisticsReportResponse.ReadOnly
  ]
  def getDedicatedIps(
      request: zio.aws.pinpointemail.model.GetDedicatedIpsRequest
  ): ZStream[Any, AwsError, zio.aws.pinpointemail.model.DedicatedIp.ReadOnly]
  def getDedicatedIpsPaginated(
      request: zio.aws.pinpointemail.model.GetDedicatedIpsRequest
  ): IO[AwsError, zio.aws.pinpointemail.model.GetDedicatedIpsResponse.ReadOnly]
  def createDeliverabilityTestReport(
      request: zio.aws.pinpointemail.model.CreateDeliverabilityTestReportRequest
  ): IO[
    AwsError,
    zio.aws.pinpointemail.model.CreateDeliverabilityTestReportResponse.ReadOnly
  ]
  def listDomainDeliverabilityCampaigns(
      request: zio.aws.pinpointemail.model.ListDomainDeliverabilityCampaignsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.pinpointemail.model.DomainDeliverabilityCampaign.ReadOnly
  ]
  def listDomainDeliverabilityCampaignsPaginated(
      request: zio.aws.pinpointemail.model.ListDomainDeliverabilityCampaignsRequest
  ): IO[
    AwsError,
    zio.aws.pinpointemail.model.ListDomainDeliverabilityCampaignsResponse.ReadOnly
  ]
  def getBlacklistReports(
      request: zio.aws.pinpointemail.model.GetBlacklistReportsRequest
  ): IO[
    AwsError,
    zio.aws.pinpointemail.model.GetBlacklistReportsResponse.ReadOnly
  ]
  def untagResource(
      request: zio.aws.pinpointemail.model.UntagResourceRequest
  ): IO[AwsError, zio.aws.pinpointemail.model.UntagResourceResponse.ReadOnly]
  def createDedicatedIpPool(
      request: zio.aws.pinpointemail.model.CreateDedicatedIpPoolRequest
  ): IO[
    AwsError,
    zio.aws.pinpointemail.model.CreateDedicatedIpPoolResponse.ReadOnly
  ]
  def listConfigurationSets(
      request: zio.aws.pinpointemail.model.ListConfigurationSetsRequest
  ): ZStream[Any, AwsError, ConfigurationSetName]
  def listConfigurationSetsPaginated(
      request: zio.aws.pinpointemail.model.ListConfigurationSetsRequest
  ): IO[
    AwsError,
    zio.aws.pinpointemail.model.ListConfigurationSetsResponse.ReadOnly
  ]
  def putEmailIdentityMailFromAttributes(
      request: zio.aws.pinpointemail.model.PutEmailIdentityMailFromAttributesRequest
  ): IO[
    AwsError,
    zio.aws.pinpointemail.model.PutEmailIdentityMailFromAttributesResponse.ReadOnly
  ]
  def putEmailIdentityFeedbackAttributes(
      request: zio.aws.pinpointemail.model.PutEmailIdentityFeedbackAttributesRequest
  ): IO[
    AwsError,
    zio.aws.pinpointemail.model.PutEmailIdentityFeedbackAttributesResponse.ReadOnly
  ]
  def listTagsForResource(
      request: zio.aws.pinpointemail.model.ListTagsForResourceRequest
  ): IO[
    AwsError,
    zio.aws.pinpointemail.model.ListTagsForResourceResponse.ReadOnly
  ]
  def deleteDedicatedIpPool(
      request: zio.aws.pinpointemail.model.DeleteDedicatedIpPoolRequest
  ): IO[
    AwsError,
    zio.aws.pinpointemail.model.DeleteDedicatedIpPoolResponse.ReadOnly
  ]
  def getDedicatedIp(
      request: zio.aws.pinpointemail.model.GetDedicatedIpRequest
  ): IO[AwsError, zio.aws.pinpointemail.model.GetDedicatedIpResponse.ReadOnly]
  def putDeliverabilityDashboardOption(
      request: zio.aws.pinpointemail.model.PutDeliverabilityDashboardOptionRequest
  ): IO[
    AwsError,
    zio.aws.pinpointemail.model.PutDeliverabilityDashboardOptionResponse.ReadOnly
  ]
  def tagResource(
      request: zio.aws.pinpointemail.model.TagResourceRequest
  ): IO[AwsError, zio.aws.pinpointemail.model.TagResourceResponse.ReadOnly]
  def deleteConfigurationSet(
      request: zio.aws.pinpointemail.model.DeleteConfigurationSetRequest
  ): IO[
    AwsError,
    zio.aws.pinpointemail.model.DeleteConfigurationSetResponse.ReadOnly
  ]
  def createConfigurationSet(
      request: zio.aws.pinpointemail.model.CreateConfigurationSetRequest
  ): IO[
    AwsError,
    zio.aws.pinpointemail.model.CreateConfigurationSetResponse.ReadOnly
  ]
  def listDeliverabilityTestReports(
      request: zio.aws.pinpointemail.model.ListDeliverabilityTestReportsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.pinpointemail.model.DeliverabilityTestReport.ReadOnly
  ]
  def listDeliverabilityTestReportsPaginated(
      request: zio.aws.pinpointemail.model.ListDeliverabilityTestReportsRequest
  ): IO[
    AwsError,
    zio.aws.pinpointemail.model.ListDeliverabilityTestReportsResponse.ReadOnly
  ]
  def updateConfigurationSetEventDestination(
      request: zio.aws.pinpointemail.model.UpdateConfigurationSetEventDestinationRequest
  ): IO[
    AwsError,
    zio.aws.pinpointemail.model.UpdateConfigurationSetEventDestinationResponse.ReadOnly
  ]
  def putDedicatedIpInPool(
      request: zio.aws.pinpointemail.model.PutDedicatedIpInPoolRequest
  ): IO[
    AwsError,
    zio.aws.pinpointemail.model.PutDedicatedIpInPoolResponse.ReadOnly
  ]
  def putConfigurationSetSendingOptions(
      request: zio.aws.pinpointemail.model.PutConfigurationSetSendingOptionsRequest
  ): IO[
    AwsError,
    zio.aws.pinpointemail.model.PutConfigurationSetSendingOptionsResponse.ReadOnly
  ]
  def putConfigurationSetDeliveryOptions(
      request: zio.aws.pinpointemail.model.PutConfigurationSetDeliveryOptionsRequest
  ): IO[
    AwsError,
    zio.aws.pinpointemail.model.PutConfigurationSetDeliveryOptionsResponse.ReadOnly
  ]
  def getDeliverabilityTestReport(
      request: zio.aws.pinpointemail.model.GetDeliverabilityTestReportRequest
  ): IO[
    AwsError,
    zio.aws.pinpointemail.model.GetDeliverabilityTestReportResponse.ReadOnly
  ]
  def putDedicatedIpWarmupAttributes(
      request: zio.aws.pinpointemail.model.PutDedicatedIpWarmupAttributesRequest
  ): IO[
    AwsError,
    zio.aws.pinpointemail.model.PutDedicatedIpWarmupAttributesResponse.ReadOnly
  ]
  def deleteConfigurationSetEventDestination(
      request: zio.aws.pinpointemail.model.DeleteConfigurationSetEventDestinationRequest
  ): IO[
    AwsError,
    zio.aws.pinpointemail.model.DeleteConfigurationSetEventDestinationResponse.ReadOnly
  ]
  def putEmailIdentityDkimAttributes(
      request: zio.aws.pinpointemail.model.PutEmailIdentityDkimAttributesRequest
  ): IO[
    AwsError,
    zio.aws.pinpointemail.model.PutEmailIdentityDkimAttributesResponse.ReadOnly
  ]
}
object PinpointEmail {
  val live: ZLayer[AwsConfig, java.lang.Throwable, PinpointEmail] = customized(
    identity
  )
  def customized(
      customization: PinpointEmailAsyncClientBuilder => PinpointEmailAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, PinpointEmail] = managed(
    customization
  ).toLayer
  def managed(
      customization: PinpointEmailAsyncClientBuilder => PinpointEmailAsyncClientBuilder
  ): ZManaged[AwsConfig, java.lang.Throwable, PinpointEmail] = for (
    awsConfig <- ZManaged.service[AwsConfig];
    executor <- ZIO.executor.toManaged;
    builder = PinpointEmailAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig
      .configure[PinpointEmailAsyncClient, PinpointEmailAsyncClientBuilder](
        builder
      )
      .toManaged;
    b1 <- awsConfig
      .configureHttpClient[
        PinpointEmailAsyncClient,
        PinpointEmailAsyncClientBuilder
      ](
        b0,
        zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
      )
      .toManaged; client <- zio.ZIO(customization(b1).build()).toManaged
  )
    yield new PinpointEmailImpl(
      client,
      AwsCallAspect.identity,
      ZEnvironment.empty
    )
  private class PinpointEmailImpl[R](
      override val api: PinpointEmailAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends PinpointEmail
      with AwsServiceBase[R] {
    override val serviceName: String = "PinpointEmail"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): PinpointEmailImpl[R1] = new PinpointEmailImpl(api, newAspect, r)
    def getConfigurationSet(
        request: zio.aws.pinpointemail.model.GetConfigurationSetRequest
    ): IO[
      AwsError,
      zio.aws.pinpointemail.model.GetConfigurationSetResponse.ReadOnly
    ] = asyncRequestResponse[
      GetConfigurationSetRequest,
      GetConfigurationSetResponse
    ]("getConfigurationSet", api.getConfigurationSet)(request.buildAwsValue())
      .map(zio.aws.pinpointemail.model.GetConfigurationSetResponse.wrap)
      .provideEnvironment(r)
    def getDomainDeliverabilityCampaign(
        request: zio.aws.pinpointemail.model.GetDomainDeliverabilityCampaignRequest
    ): IO[
      AwsError,
      zio.aws.pinpointemail.model.GetDomainDeliverabilityCampaignResponse.ReadOnly
    ] = asyncRequestResponse[
      GetDomainDeliverabilityCampaignRequest,
      GetDomainDeliverabilityCampaignResponse
    ]("getDomainDeliverabilityCampaign", api.getDomainDeliverabilityCampaign)(
      request.buildAwsValue()
    ).map(
      zio.aws.pinpointemail.model.GetDomainDeliverabilityCampaignResponse.wrap
    ).provideEnvironment(r)
    def createConfigurationSetEventDestination(
        request: zio.aws.pinpointemail.model.CreateConfigurationSetEventDestinationRequest
    ): IO[AwsError, ReadOnly] = asyncRequestResponse[
      CreateConfigurationSetEventDestinationRequest,
      CreateConfigurationSetEventDestinationResponse
    ](
      "createConfigurationSetEventDestination",
      api.createConfigurationSetEventDestination
    )(request.buildAwsValue())
      .map(
        zio.aws.pinpointemail.model.CreateConfigurationSetEventDestinationResponse.wrap
      )
      .provideEnvironment(r)
    def putConfigurationSetReputationOptions(
        request: zio.aws.pinpointemail.model.PutConfigurationSetReputationOptionsRequest
    ): IO[
      AwsError,
      zio.aws.pinpointemail.model.PutConfigurationSetReputationOptionsResponse.ReadOnly
    ] = asyncRequestResponse[
      PutConfigurationSetReputationOptionsRequest,
      PutConfigurationSetReputationOptionsResponse
    ](
      "putConfigurationSetReputationOptions",
      api.putConfigurationSetReputationOptions
    )(request.buildAwsValue())
      .map(
        zio.aws.pinpointemail.model.PutConfigurationSetReputationOptionsResponse.wrap
      )
      .provideEnvironment(r)
    def putAccountSendingAttributes(
        request: zio.aws.pinpointemail.model.PutAccountSendingAttributesRequest
    ): IO[
      AwsError,
      zio.aws.pinpointemail.model.PutAccountSendingAttributesResponse.ReadOnly
    ] = asyncRequestResponse[
      PutAccountSendingAttributesRequest,
      PutAccountSendingAttributesResponse
    ]("putAccountSendingAttributes", api.putAccountSendingAttributes)(
      request.buildAwsValue()
    ).map(zio.aws.pinpointemail.model.PutAccountSendingAttributesResponse.wrap)
      .provideEnvironment(r)
    def listEmailIdentities(
        request: zio.aws.pinpointemail.model.ListEmailIdentitiesRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.pinpointemail.model.IdentityInfo.ReadOnly
    ] = asyncSimplePaginatedRequest[
      ListEmailIdentitiesRequest,
      ListEmailIdentitiesResponse,
      IdentityInfo
    ](
      "listEmailIdentities",
      api.listEmailIdentities,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.emailIdentities().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.pinpointemail.model.IdentityInfo.wrap(item))
      .provideEnvironment(r)
    def listEmailIdentitiesPaginated(
        request: zio.aws.pinpointemail.model.ListEmailIdentitiesRequest
    ): IO[
      AwsError,
      zio.aws.pinpointemail.model.ListEmailIdentitiesResponse.ReadOnly
    ] = asyncRequestResponse[
      ListEmailIdentitiesRequest,
      ListEmailIdentitiesResponse
    ]("listEmailIdentities", api.listEmailIdentities)(request.buildAwsValue())
      .map(zio.aws.pinpointemail.model.ListEmailIdentitiesResponse.wrap)
      .provideEnvironment(r)
    def createEmailIdentity(
        request: zio.aws.pinpointemail.model.CreateEmailIdentityRequest
    ): IO[
      AwsError,
      zio.aws.pinpointemail.model.CreateEmailIdentityResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateEmailIdentityRequest,
      CreateEmailIdentityResponse
    ]("createEmailIdentity", api.createEmailIdentity)(request.buildAwsValue())
      .map(zio.aws.pinpointemail.model.CreateEmailIdentityResponse.wrap)
      .provideEnvironment(r)
    def listDedicatedIpPools(
        request: zio.aws.pinpointemail.model.ListDedicatedIpPoolsRequest
    ): ZStream[Any, AwsError, PoolName] = asyncSimplePaginatedRequest[
      ListDedicatedIpPoolsRequest,
      ListDedicatedIpPoolsResponse,
      java.lang.String
    ](
      "listDedicatedIpPools",
      api.listDedicatedIpPools,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.dedicatedIpPools().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.pinpointemail.model.primitives.PoolName(item))
      .provideEnvironment(r)
    def listDedicatedIpPoolsPaginated(
        request: zio.aws.pinpointemail.model.ListDedicatedIpPoolsRequest
    ): IO[
      AwsError,
      zio.aws.pinpointemail.model.ListDedicatedIpPoolsResponse.ReadOnly
    ] = asyncRequestResponse[
      ListDedicatedIpPoolsRequest,
      ListDedicatedIpPoolsResponse
    ]("listDedicatedIpPools", api.listDedicatedIpPools)(request.buildAwsValue())
      .map(zio.aws.pinpointemail.model.ListDedicatedIpPoolsResponse.wrap)
      .provideEnvironment(r)
    def putAccountDedicatedIpWarmupAttributes(
        request: zio.aws.pinpointemail.model.PutAccountDedicatedIpWarmupAttributesRequest
    ): IO[
      AwsError,
      zio.aws.pinpointemail.model.PutAccountDedicatedIpWarmupAttributesResponse.ReadOnly
    ] = asyncRequestResponse[
      PutAccountDedicatedIpWarmupAttributesRequest,
      PutAccountDedicatedIpWarmupAttributesResponse
    ](
      "putAccountDedicatedIpWarmupAttributes",
      api.putAccountDedicatedIpWarmupAttributes
    )(request.buildAwsValue())
      .map(
        zio.aws.pinpointemail.model.PutAccountDedicatedIpWarmupAttributesResponse.wrap
      )
      .provideEnvironment(r)
    def getConfigurationSetEventDestinations(
        request: zio.aws.pinpointemail.model.GetConfigurationSetEventDestinationsRequest
    ): IO[
      AwsError,
      zio.aws.pinpointemail.model.GetConfigurationSetEventDestinationsResponse.ReadOnly
    ] = asyncRequestResponse[
      GetConfigurationSetEventDestinationsRequest,
      GetConfigurationSetEventDestinationsResponse
    ](
      "getConfigurationSetEventDestinations",
      api.getConfigurationSetEventDestinations
    )(request.buildAwsValue())
      .map(
        zio.aws.pinpointemail.model.GetConfigurationSetEventDestinationsResponse.wrap
      )
      .provideEnvironment(r)
    def sendEmail(
        request: zio.aws.pinpointemail.model.SendEmailRequest
    ): IO[AwsError, zio.aws.pinpointemail.model.SendEmailResponse.ReadOnly] =
      asyncRequestResponse[SendEmailRequest, SendEmailResponse](
        "sendEmail",
        api.sendEmail
      )(request.buildAwsValue())
        .map(zio.aws.pinpointemail.model.SendEmailResponse.wrap)
        .provideEnvironment(r)
    def getEmailIdentity(
        request: zio.aws.pinpointemail.model.GetEmailIdentityRequest
    ): IO[
      AwsError,
      zio.aws.pinpointemail.model.GetEmailIdentityResponse.ReadOnly
    ] = asyncRequestResponse[GetEmailIdentityRequest, GetEmailIdentityResponse](
      "getEmailIdentity",
      api.getEmailIdentity
    )(request.buildAwsValue())
      .map(zio.aws.pinpointemail.model.GetEmailIdentityResponse.wrap)
      .provideEnvironment(r)
    def putConfigurationSetTrackingOptions(
        request: zio.aws.pinpointemail.model.PutConfigurationSetTrackingOptionsRequest
    ): IO[
      AwsError,
      zio.aws.pinpointemail.model.PutConfigurationSetTrackingOptionsResponse.ReadOnly
    ] = asyncRequestResponse[
      PutConfigurationSetTrackingOptionsRequest,
      PutConfigurationSetTrackingOptionsResponse
    ](
      "putConfigurationSetTrackingOptions",
      api.putConfigurationSetTrackingOptions
    )(request.buildAwsValue())
      .map(
        zio.aws.pinpointemail.model.PutConfigurationSetTrackingOptionsResponse.wrap
      )
      .provideEnvironment(r)
    def deleteEmailIdentity(
        request: zio.aws.pinpointemail.model.DeleteEmailIdentityRequest
    ): IO[
      AwsError,
      zio.aws.pinpointemail.model.DeleteEmailIdentityResponse.ReadOnly
    ] = asyncRequestResponse[
      DeleteEmailIdentityRequest,
      DeleteEmailIdentityResponse
    ]("deleteEmailIdentity", api.deleteEmailIdentity)(request.buildAwsValue())
      .map(zio.aws.pinpointemail.model.DeleteEmailIdentityResponse.wrap)
      .provideEnvironment(r)
    def getDeliverabilityDashboardOptions(
        request: zio.aws.pinpointemail.model.GetDeliverabilityDashboardOptionsRequest
    ): IO[
      AwsError,
      zio.aws.pinpointemail.model.GetDeliverabilityDashboardOptionsResponse.ReadOnly
    ] = asyncRequestResponse[
      GetDeliverabilityDashboardOptionsRequest,
      GetDeliverabilityDashboardOptionsResponse
    ](
      "getDeliverabilityDashboardOptions",
      api.getDeliverabilityDashboardOptions
    )(request.buildAwsValue())
      .map(
        zio.aws.pinpointemail.model.GetDeliverabilityDashboardOptionsResponse.wrap
      )
      .provideEnvironment(r)
    def getAccount(
        request: zio.aws.pinpointemail.model.GetAccountRequest
    ): IO[AwsError, zio.aws.pinpointemail.model.GetAccountResponse.ReadOnly] =
      asyncRequestResponse[GetAccountRequest, GetAccountResponse](
        "getAccount",
        api.getAccount
      )(request.buildAwsValue())
        .map(zio.aws.pinpointemail.model.GetAccountResponse.wrap)
        .provideEnvironment(r)
    def getDomainStatisticsReport(
        request: zio.aws.pinpointemail.model.GetDomainStatisticsReportRequest
    ): IO[
      AwsError,
      zio.aws.pinpointemail.model.GetDomainStatisticsReportResponse.ReadOnly
    ] = asyncRequestResponse[
      GetDomainStatisticsReportRequest,
      GetDomainStatisticsReportResponse
    ]("getDomainStatisticsReport", api.getDomainStatisticsReport)(
      request.buildAwsValue()
    ).map(zio.aws.pinpointemail.model.GetDomainStatisticsReportResponse.wrap)
      .provideEnvironment(r)
    def getDedicatedIps(
        request: zio.aws.pinpointemail.model.GetDedicatedIpsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.pinpointemail.model.DedicatedIp.ReadOnly
    ] = asyncSimplePaginatedRequest[
      GetDedicatedIpsRequest,
      GetDedicatedIpsResponse,
      DedicatedIp
    ](
      "getDedicatedIps",
      api.getDedicatedIps,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.dedicatedIps().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.pinpointemail.model.DedicatedIp.wrap(item))
      .provideEnvironment(r)
    def getDedicatedIpsPaginated(
        request: zio.aws.pinpointemail.model.GetDedicatedIpsRequest
    ): IO[
      AwsError,
      zio.aws.pinpointemail.model.GetDedicatedIpsResponse.ReadOnly
    ] = asyncRequestResponse[GetDedicatedIpsRequest, GetDedicatedIpsResponse](
      "getDedicatedIps",
      api.getDedicatedIps
    )(request.buildAwsValue())
      .map(zio.aws.pinpointemail.model.GetDedicatedIpsResponse.wrap)
      .provideEnvironment(r)
    def createDeliverabilityTestReport(
        request: zio.aws.pinpointemail.model.CreateDeliverabilityTestReportRequest
    ): IO[
      AwsError,
      zio.aws.pinpointemail.model.CreateDeliverabilityTestReportResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateDeliverabilityTestReportRequest,
      CreateDeliverabilityTestReportResponse
    ]("createDeliverabilityTestReport", api.createDeliverabilityTestReport)(
      request.buildAwsValue()
    ).map(
      zio.aws.pinpointemail.model.CreateDeliverabilityTestReportResponse.wrap
    ).provideEnvironment(r)
    def listDomainDeliverabilityCampaigns(
        request: zio.aws.pinpointemail.model.ListDomainDeliverabilityCampaignsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.pinpointemail.model.DomainDeliverabilityCampaign.ReadOnly
    ] = asyncSimplePaginatedRequest[
      ListDomainDeliverabilityCampaignsRequest,
      ListDomainDeliverabilityCampaignsResponse,
      DomainDeliverabilityCampaign
    ](
      "listDomainDeliverabilityCampaigns",
      api.listDomainDeliverabilityCampaigns,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.domainDeliverabilityCampaigns().asScala)
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.pinpointemail.model.DomainDeliverabilityCampaign.wrap(item)
      )
      .provideEnvironment(r)
    def listDomainDeliverabilityCampaignsPaginated(
        request: zio.aws.pinpointemail.model.ListDomainDeliverabilityCampaignsRequest
    ): IO[
      AwsError,
      zio.aws.pinpointemail.model.ListDomainDeliverabilityCampaignsResponse.ReadOnly
    ] = asyncRequestResponse[
      ListDomainDeliverabilityCampaignsRequest,
      ListDomainDeliverabilityCampaignsResponse
    ](
      "listDomainDeliverabilityCampaigns",
      api.listDomainDeliverabilityCampaigns
    )(request.buildAwsValue())
      .map(
        zio.aws.pinpointemail.model.ListDomainDeliverabilityCampaignsResponse.wrap
      )
      .provideEnvironment(r)
    def getBlacklistReports(
        request: zio.aws.pinpointemail.model.GetBlacklistReportsRequest
    ): IO[
      AwsError,
      zio.aws.pinpointemail.model.GetBlacklistReportsResponse.ReadOnly
    ] = asyncRequestResponse[
      GetBlacklistReportsRequest,
      GetBlacklistReportsResponse
    ]("getBlacklistReports", api.getBlacklistReports)(request.buildAwsValue())
      .map(zio.aws.pinpointemail.model.GetBlacklistReportsResponse.wrap)
      .provideEnvironment(r)
    def untagResource(
        request: zio.aws.pinpointemail.model.UntagResourceRequest
    ): IO[
      AwsError,
      zio.aws.pinpointemail.model.UntagResourceResponse.ReadOnly
    ] = asyncRequestResponse[UntagResourceRequest, UntagResourceResponse](
      "untagResource",
      api.untagResource
    )(request.buildAwsValue())
      .map(zio.aws.pinpointemail.model.UntagResourceResponse.wrap)
      .provideEnvironment(r)
    def createDedicatedIpPool(
        request: zio.aws.pinpointemail.model.CreateDedicatedIpPoolRequest
    ): IO[
      AwsError,
      zio.aws.pinpointemail.model.CreateDedicatedIpPoolResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateDedicatedIpPoolRequest,
      CreateDedicatedIpPoolResponse
    ]("createDedicatedIpPool", api.createDedicatedIpPool)(
      request.buildAwsValue()
    ).map(zio.aws.pinpointemail.model.CreateDedicatedIpPoolResponse.wrap)
      .provideEnvironment(r)
    def listConfigurationSets(
        request: zio.aws.pinpointemail.model.ListConfigurationSetsRequest
    ): ZStream[Any, AwsError, ConfigurationSetName] =
      asyncSimplePaginatedRequest[
        ListConfigurationSetsRequest,
        ListConfigurationSetsResponse,
        java.lang.String
      ](
        "listConfigurationSets",
        api.listConfigurationSets,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.configurationSets().asScala)
      )(request.buildAwsValue())
        .map(item =>
          zio.aws.pinpointemail.model.primitives.ConfigurationSetName(item)
        )
        .provideEnvironment(r)
    def listConfigurationSetsPaginated(
        request: zio.aws.pinpointemail.model.ListConfigurationSetsRequest
    ): IO[
      AwsError,
      zio.aws.pinpointemail.model.ListConfigurationSetsResponse.ReadOnly
    ] = asyncRequestResponse[
      ListConfigurationSetsRequest,
      ListConfigurationSetsResponse
    ]("listConfigurationSets", api.listConfigurationSets)(
      request.buildAwsValue()
    ).map(zio.aws.pinpointemail.model.ListConfigurationSetsResponse.wrap)
      .provideEnvironment(r)
    def putEmailIdentityMailFromAttributes(
        request: zio.aws.pinpointemail.model.PutEmailIdentityMailFromAttributesRequest
    ): IO[
      AwsError,
      zio.aws.pinpointemail.model.PutEmailIdentityMailFromAttributesResponse.ReadOnly
    ] = asyncRequestResponse[
      PutEmailIdentityMailFromAttributesRequest,
      PutEmailIdentityMailFromAttributesResponse
    ](
      "putEmailIdentityMailFromAttributes",
      api.putEmailIdentityMailFromAttributes
    )(request.buildAwsValue())
      .map(
        zio.aws.pinpointemail.model.PutEmailIdentityMailFromAttributesResponse.wrap
      )
      .provideEnvironment(r)
    def putEmailIdentityFeedbackAttributes(
        request: zio.aws.pinpointemail.model.PutEmailIdentityFeedbackAttributesRequest
    ): IO[
      AwsError,
      zio.aws.pinpointemail.model.PutEmailIdentityFeedbackAttributesResponse.ReadOnly
    ] = asyncRequestResponse[
      PutEmailIdentityFeedbackAttributesRequest,
      PutEmailIdentityFeedbackAttributesResponse
    ](
      "putEmailIdentityFeedbackAttributes",
      api.putEmailIdentityFeedbackAttributes
    )(request.buildAwsValue())
      .map(
        zio.aws.pinpointemail.model.PutEmailIdentityFeedbackAttributesResponse.wrap
      )
      .provideEnvironment(r)
    def listTagsForResource(
        request: zio.aws.pinpointemail.model.ListTagsForResourceRequest
    ): IO[
      AwsError,
      zio.aws.pinpointemail.model.ListTagsForResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      ListTagsForResourceRequest,
      ListTagsForResourceResponse
    ]("listTagsForResource", api.listTagsForResource)(request.buildAwsValue())
      .map(zio.aws.pinpointemail.model.ListTagsForResourceResponse.wrap)
      .provideEnvironment(r)
    def deleteDedicatedIpPool(
        request: zio.aws.pinpointemail.model.DeleteDedicatedIpPoolRequest
    ): IO[
      AwsError,
      zio.aws.pinpointemail.model.DeleteDedicatedIpPoolResponse.ReadOnly
    ] = asyncRequestResponse[
      DeleteDedicatedIpPoolRequest,
      DeleteDedicatedIpPoolResponse
    ]("deleteDedicatedIpPool", api.deleteDedicatedIpPool)(
      request.buildAwsValue()
    ).map(zio.aws.pinpointemail.model.DeleteDedicatedIpPoolResponse.wrap)
      .provideEnvironment(r)
    def getDedicatedIp(
        request: zio.aws.pinpointemail.model.GetDedicatedIpRequest
    ): IO[
      AwsError,
      zio.aws.pinpointemail.model.GetDedicatedIpResponse.ReadOnly
    ] = asyncRequestResponse[GetDedicatedIpRequest, GetDedicatedIpResponse](
      "getDedicatedIp",
      api.getDedicatedIp
    )(request.buildAwsValue())
      .map(zio.aws.pinpointemail.model.GetDedicatedIpResponse.wrap)
      .provideEnvironment(r)
    def putDeliverabilityDashboardOption(
        request: zio.aws.pinpointemail.model.PutDeliverabilityDashboardOptionRequest
    ): IO[
      AwsError,
      zio.aws.pinpointemail.model.PutDeliverabilityDashboardOptionResponse.ReadOnly
    ] = asyncRequestResponse[
      PutDeliverabilityDashboardOptionRequest,
      PutDeliverabilityDashboardOptionResponse
    ]("putDeliverabilityDashboardOption", api.putDeliverabilityDashboardOption)(
      request.buildAwsValue()
    ).map(
      zio.aws.pinpointemail.model.PutDeliverabilityDashboardOptionResponse.wrap
    ).provideEnvironment(r)
    def tagResource(
        request: zio.aws.pinpointemail.model.TagResourceRequest
    ): IO[AwsError, zio.aws.pinpointemail.model.TagResourceResponse.ReadOnly] =
      asyncRequestResponse[TagResourceRequest, TagResourceResponse](
        "tagResource",
        api.tagResource
      )(request.buildAwsValue())
        .map(zio.aws.pinpointemail.model.TagResourceResponse.wrap)
        .provideEnvironment(r)
    def deleteConfigurationSet(
        request: zio.aws.pinpointemail.model.DeleteConfigurationSetRequest
    ): IO[
      AwsError,
      zio.aws.pinpointemail.model.DeleteConfigurationSetResponse.ReadOnly
    ] = asyncRequestResponse[
      DeleteConfigurationSetRequest,
      DeleteConfigurationSetResponse
    ]("deleteConfigurationSet", api.deleteConfigurationSet)(
      request.buildAwsValue()
    ).map(zio.aws.pinpointemail.model.DeleteConfigurationSetResponse.wrap)
      .provideEnvironment(r)
    def createConfigurationSet(
        request: zio.aws.pinpointemail.model.CreateConfigurationSetRequest
    ): IO[
      AwsError,
      zio.aws.pinpointemail.model.CreateConfigurationSetResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateConfigurationSetRequest,
      CreateConfigurationSetResponse
    ]("createConfigurationSet", api.createConfigurationSet)(
      request.buildAwsValue()
    ).map(zio.aws.pinpointemail.model.CreateConfigurationSetResponse.wrap)
      .provideEnvironment(r)
    def listDeliverabilityTestReports(
        request: zio.aws.pinpointemail.model.ListDeliverabilityTestReportsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.pinpointemail.model.DeliverabilityTestReport.ReadOnly
    ] = asyncSimplePaginatedRequest[
      ListDeliverabilityTestReportsRequest,
      ListDeliverabilityTestReportsResponse,
      DeliverabilityTestReport
    ](
      "listDeliverabilityTestReports",
      api.listDeliverabilityTestReports,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.deliverabilityTestReports().asScala)
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.pinpointemail.model.DeliverabilityTestReport.wrap(item)
      )
      .provideEnvironment(r)
    def listDeliverabilityTestReportsPaginated(
        request: zio.aws.pinpointemail.model.ListDeliverabilityTestReportsRequest
    ): IO[
      AwsError,
      zio.aws.pinpointemail.model.ListDeliverabilityTestReportsResponse.ReadOnly
    ] = asyncRequestResponse[
      ListDeliverabilityTestReportsRequest,
      ListDeliverabilityTestReportsResponse
    ]("listDeliverabilityTestReports", api.listDeliverabilityTestReports)(
      request.buildAwsValue()
    ).map(
      zio.aws.pinpointemail.model.ListDeliverabilityTestReportsResponse.wrap
    ).provideEnvironment(r)
    def updateConfigurationSetEventDestination(
        request: zio.aws.pinpointemail.model.UpdateConfigurationSetEventDestinationRequest
    ): IO[
      AwsError,
      zio.aws.pinpointemail.model.UpdateConfigurationSetEventDestinationResponse.ReadOnly
    ] = asyncRequestResponse[
      UpdateConfigurationSetEventDestinationRequest,
      UpdateConfigurationSetEventDestinationResponse
    ](
      "updateConfigurationSetEventDestination",
      api.updateConfigurationSetEventDestination
    )(request.buildAwsValue())
      .map(
        zio.aws.pinpointemail.model.UpdateConfigurationSetEventDestinationResponse.wrap
      )
      .provideEnvironment(r)
    def putDedicatedIpInPool(
        request: zio.aws.pinpointemail.model.PutDedicatedIpInPoolRequest
    ): IO[
      AwsError,
      zio.aws.pinpointemail.model.PutDedicatedIpInPoolResponse.ReadOnly
    ] = asyncRequestResponse[
      PutDedicatedIpInPoolRequest,
      PutDedicatedIpInPoolResponse
    ]("putDedicatedIpInPool", api.putDedicatedIpInPool)(request.buildAwsValue())
      .map(zio.aws.pinpointemail.model.PutDedicatedIpInPoolResponse.wrap)
      .provideEnvironment(r)
    def putConfigurationSetSendingOptions(
        request: zio.aws.pinpointemail.model.PutConfigurationSetSendingOptionsRequest
    ): IO[
      AwsError,
      zio.aws.pinpointemail.model.PutConfigurationSetSendingOptionsResponse.ReadOnly
    ] = asyncRequestResponse[
      PutConfigurationSetSendingOptionsRequest,
      PutConfigurationSetSendingOptionsResponse
    ](
      "putConfigurationSetSendingOptions",
      api.putConfigurationSetSendingOptions
    )(request.buildAwsValue())
      .map(
        zio.aws.pinpointemail.model.PutConfigurationSetSendingOptionsResponse.wrap
      )
      .provideEnvironment(r)
    def putConfigurationSetDeliveryOptions(
        request: zio.aws.pinpointemail.model.PutConfigurationSetDeliveryOptionsRequest
    ): IO[
      AwsError,
      zio.aws.pinpointemail.model.PutConfigurationSetDeliveryOptionsResponse.ReadOnly
    ] = asyncRequestResponse[
      PutConfigurationSetDeliveryOptionsRequest,
      PutConfigurationSetDeliveryOptionsResponse
    ](
      "putConfigurationSetDeliveryOptions",
      api.putConfigurationSetDeliveryOptions
    )(request.buildAwsValue())
      .map(
        zio.aws.pinpointemail.model.PutConfigurationSetDeliveryOptionsResponse.wrap
      )
      .provideEnvironment(r)
    def getDeliverabilityTestReport(
        request: zio.aws.pinpointemail.model.GetDeliverabilityTestReportRequest
    ): IO[
      AwsError,
      zio.aws.pinpointemail.model.GetDeliverabilityTestReportResponse.ReadOnly
    ] = asyncRequestResponse[
      GetDeliverabilityTestReportRequest,
      GetDeliverabilityTestReportResponse
    ]("getDeliverabilityTestReport", api.getDeliverabilityTestReport)(
      request.buildAwsValue()
    ).map(zio.aws.pinpointemail.model.GetDeliverabilityTestReportResponse.wrap)
      .provideEnvironment(r)
    def putDedicatedIpWarmupAttributes(
        request: zio.aws.pinpointemail.model.PutDedicatedIpWarmupAttributesRequest
    ): IO[
      AwsError,
      zio.aws.pinpointemail.model.PutDedicatedIpWarmupAttributesResponse.ReadOnly
    ] = asyncRequestResponse[
      PutDedicatedIpWarmupAttributesRequest,
      PutDedicatedIpWarmupAttributesResponse
    ]("putDedicatedIpWarmupAttributes", api.putDedicatedIpWarmupAttributes)(
      request.buildAwsValue()
    ).map(
      zio.aws.pinpointemail.model.PutDedicatedIpWarmupAttributesResponse.wrap
    ).provideEnvironment(r)
    def deleteConfigurationSetEventDestination(
        request: zio.aws.pinpointemail.model.DeleteConfigurationSetEventDestinationRequest
    ): IO[
      AwsError,
      zio.aws.pinpointemail.model.DeleteConfigurationSetEventDestinationResponse.ReadOnly
    ] = asyncRequestResponse[
      DeleteConfigurationSetEventDestinationRequest,
      DeleteConfigurationSetEventDestinationResponse
    ](
      "deleteConfigurationSetEventDestination",
      api.deleteConfigurationSetEventDestination
    )(request.buildAwsValue())
      .map(
        zio.aws.pinpointemail.model.DeleteConfigurationSetEventDestinationResponse.wrap
      )
      .provideEnvironment(r)
    def putEmailIdentityDkimAttributes(
        request: zio.aws.pinpointemail.model.PutEmailIdentityDkimAttributesRequest
    ): IO[
      AwsError,
      zio.aws.pinpointemail.model.PutEmailIdentityDkimAttributesResponse.ReadOnly
    ] = asyncRequestResponse[
      PutEmailIdentityDkimAttributesRequest,
      PutEmailIdentityDkimAttributesResponse
    ]("putEmailIdentityDkimAttributes", api.putEmailIdentityDkimAttributes)(
      request.buildAwsValue()
    ).map(
      zio.aws.pinpointemail.model.PutEmailIdentityDkimAttributesResponse.wrap
    ).provideEnvironment(r)
  }
  def getConfigurationSet(
      request: zio.aws.pinpointemail.model.GetConfigurationSetRequest
  ): ZIO[
    zio.aws.pinpointemail.PinpointEmail,
    AwsError,
    zio.aws.pinpointemail.model.GetConfigurationSetResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getConfigurationSet(request))
  def getDomainDeliverabilityCampaign(
      request: zio.aws.pinpointemail.model.GetDomainDeliverabilityCampaignRequest
  ): ZIO[
    zio.aws.pinpointemail.PinpointEmail,
    AwsError,
    zio.aws.pinpointemail.model.GetDomainDeliverabilityCampaignResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getDomainDeliverabilityCampaign(request))
  def createConfigurationSetEventDestination(
      request: zio.aws.pinpointemail.model.CreateConfigurationSetEventDestinationRequest
  ): ZIO[zio.aws.pinpointemail.PinpointEmail, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.createConfigurationSetEventDestination(request))
  def putConfigurationSetReputationOptions(
      request: zio.aws.pinpointemail.model.PutConfigurationSetReputationOptionsRequest
  ): ZIO[
    zio.aws.pinpointemail.PinpointEmail,
    AwsError,
    zio.aws.pinpointemail.model.PutConfigurationSetReputationOptionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putConfigurationSetReputationOptions(request))
  def putAccountSendingAttributes(
      request: zio.aws.pinpointemail.model.PutAccountSendingAttributesRequest
  ): ZIO[
    zio.aws.pinpointemail.PinpointEmail,
    AwsError,
    zio.aws.pinpointemail.model.PutAccountSendingAttributesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putAccountSendingAttributes(request))
  def listEmailIdentities(
      request: zio.aws.pinpointemail.model.ListEmailIdentitiesRequest
  ): ZStream[
    zio.aws.pinpointemail.PinpointEmail,
    AwsError,
    zio.aws.pinpointemail.model.IdentityInfo.ReadOnly
  ] = ZStream.serviceWithStream(_.listEmailIdentities(request))
  def listEmailIdentitiesPaginated(
      request: zio.aws.pinpointemail.model.ListEmailIdentitiesRequest
  ): ZIO[
    zio.aws.pinpointemail.PinpointEmail,
    AwsError,
    zio.aws.pinpointemail.model.ListEmailIdentitiesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listEmailIdentitiesPaginated(request))
  def createEmailIdentity(
      request: zio.aws.pinpointemail.model.CreateEmailIdentityRequest
  ): ZIO[
    zio.aws.pinpointemail.PinpointEmail,
    AwsError,
    zio.aws.pinpointemail.model.CreateEmailIdentityResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createEmailIdentity(request))
  def listDedicatedIpPools(
      request: zio.aws.pinpointemail.model.ListDedicatedIpPoolsRequest
  ): ZStream[zio.aws.pinpointemail.PinpointEmail, AwsError, PoolName] =
    ZStream.serviceWithStream(_.listDedicatedIpPools(request))
  def listDedicatedIpPoolsPaginated(
      request: zio.aws.pinpointemail.model.ListDedicatedIpPoolsRequest
  ): ZIO[
    zio.aws.pinpointemail.PinpointEmail,
    AwsError,
    zio.aws.pinpointemail.model.ListDedicatedIpPoolsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listDedicatedIpPoolsPaginated(request))
  def putAccountDedicatedIpWarmupAttributes(
      request: zio.aws.pinpointemail.model.PutAccountDedicatedIpWarmupAttributesRequest
  ): ZIO[
    zio.aws.pinpointemail.PinpointEmail,
    AwsError,
    zio.aws.pinpointemail.model.PutAccountDedicatedIpWarmupAttributesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putAccountDedicatedIpWarmupAttributes(request))
  def getConfigurationSetEventDestinations(
      request: zio.aws.pinpointemail.model.GetConfigurationSetEventDestinationsRequest
  ): ZIO[
    zio.aws.pinpointemail.PinpointEmail,
    AwsError,
    zio.aws.pinpointemail.model.GetConfigurationSetEventDestinationsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getConfigurationSetEventDestinations(request))
  def sendEmail(request: zio.aws.pinpointemail.model.SendEmailRequest): ZIO[
    zio.aws.pinpointemail.PinpointEmail,
    AwsError,
    zio.aws.pinpointemail.model.SendEmailResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.sendEmail(request))
  def getEmailIdentity(
      request: zio.aws.pinpointemail.model.GetEmailIdentityRequest
  ): ZIO[
    zio.aws.pinpointemail.PinpointEmail,
    AwsError,
    zio.aws.pinpointemail.model.GetEmailIdentityResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getEmailIdentity(request))
  def putConfigurationSetTrackingOptions(
      request: zio.aws.pinpointemail.model.PutConfigurationSetTrackingOptionsRequest
  ): ZIO[
    zio.aws.pinpointemail.PinpointEmail,
    AwsError,
    zio.aws.pinpointemail.model.PutConfigurationSetTrackingOptionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putConfigurationSetTrackingOptions(request))
  def deleteEmailIdentity(
      request: zio.aws.pinpointemail.model.DeleteEmailIdentityRequest
  ): ZIO[
    zio.aws.pinpointemail.PinpointEmail,
    AwsError,
    zio.aws.pinpointemail.model.DeleteEmailIdentityResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteEmailIdentity(request))
  def getDeliverabilityDashboardOptions(
      request: zio.aws.pinpointemail.model.GetDeliverabilityDashboardOptionsRequest
  ): ZIO[
    zio.aws.pinpointemail.PinpointEmail,
    AwsError,
    zio.aws.pinpointemail.model.GetDeliverabilityDashboardOptionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getDeliverabilityDashboardOptions(request))
  def getAccount(request: zio.aws.pinpointemail.model.GetAccountRequest): ZIO[
    zio.aws.pinpointemail.PinpointEmail,
    AwsError,
    zio.aws.pinpointemail.model.GetAccountResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getAccount(request))
  def getDomainStatisticsReport(
      request: zio.aws.pinpointemail.model.GetDomainStatisticsReportRequest
  ): ZIO[
    zio.aws.pinpointemail.PinpointEmail,
    AwsError,
    zio.aws.pinpointemail.model.GetDomainStatisticsReportResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getDomainStatisticsReport(request))
  def getDedicatedIps(
      request: zio.aws.pinpointemail.model.GetDedicatedIpsRequest
  ): ZStream[
    zio.aws.pinpointemail.PinpointEmail,
    AwsError,
    zio.aws.pinpointemail.model.DedicatedIp.ReadOnly
  ] = ZStream.serviceWithStream(_.getDedicatedIps(request))
  def getDedicatedIpsPaginated(
      request: zio.aws.pinpointemail.model.GetDedicatedIpsRequest
  ): ZIO[
    zio.aws.pinpointemail.PinpointEmail,
    AwsError,
    zio.aws.pinpointemail.model.GetDedicatedIpsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getDedicatedIpsPaginated(request))
  def createDeliverabilityTestReport(
      request: zio.aws.pinpointemail.model.CreateDeliverabilityTestReportRequest
  ): ZIO[
    zio.aws.pinpointemail.PinpointEmail,
    AwsError,
    zio.aws.pinpointemail.model.CreateDeliverabilityTestReportResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createDeliverabilityTestReport(request))
  def listDomainDeliverabilityCampaigns(
      request: zio.aws.pinpointemail.model.ListDomainDeliverabilityCampaignsRequest
  ): ZStream[
    zio.aws.pinpointemail.PinpointEmail,
    AwsError,
    zio.aws.pinpointemail.model.DomainDeliverabilityCampaign.ReadOnly
  ] = ZStream.serviceWithStream(_.listDomainDeliverabilityCampaigns(request))
  def listDomainDeliverabilityCampaignsPaginated(
      request: zio.aws.pinpointemail.model.ListDomainDeliverabilityCampaignsRequest
  ): ZIO[
    zio.aws.pinpointemail.PinpointEmail,
    AwsError,
    zio.aws.pinpointemail.model.ListDomainDeliverabilityCampaignsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listDomainDeliverabilityCampaignsPaginated(request))
  def getBlacklistReports(
      request: zio.aws.pinpointemail.model.GetBlacklistReportsRequest
  ): ZIO[
    zio.aws.pinpointemail.PinpointEmail,
    AwsError,
    zio.aws.pinpointemail.model.GetBlacklistReportsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getBlacklistReports(request))
  def untagResource(
      request: zio.aws.pinpointemail.model.UntagResourceRequest
  ): ZIO[
    zio.aws.pinpointemail.PinpointEmail,
    AwsError,
    zio.aws.pinpointemail.model.UntagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.untagResource(request))
  def createDedicatedIpPool(
      request: zio.aws.pinpointemail.model.CreateDedicatedIpPoolRequest
  ): ZIO[
    zio.aws.pinpointemail.PinpointEmail,
    AwsError,
    zio.aws.pinpointemail.model.CreateDedicatedIpPoolResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createDedicatedIpPool(request))
  def listConfigurationSets(
      request: zio.aws.pinpointemail.model.ListConfigurationSetsRequest
  ): ZStream[
    zio.aws.pinpointemail.PinpointEmail,
    AwsError,
    ConfigurationSetName
  ] = ZStream.serviceWithStream(_.listConfigurationSets(request))
  def listConfigurationSetsPaginated(
      request: zio.aws.pinpointemail.model.ListConfigurationSetsRequest
  ): ZIO[
    zio.aws.pinpointemail.PinpointEmail,
    AwsError,
    zio.aws.pinpointemail.model.ListConfigurationSetsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listConfigurationSetsPaginated(request))
  def putEmailIdentityMailFromAttributes(
      request: zio.aws.pinpointemail.model.PutEmailIdentityMailFromAttributesRequest
  ): ZIO[
    zio.aws.pinpointemail.PinpointEmail,
    AwsError,
    zio.aws.pinpointemail.model.PutEmailIdentityMailFromAttributesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putEmailIdentityMailFromAttributes(request))
  def putEmailIdentityFeedbackAttributes(
      request: zio.aws.pinpointemail.model.PutEmailIdentityFeedbackAttributesRequest
  ): ZIO[
    zio.aws.pinpointemail.PinpointEmail,
    AwsError,
    zio.aws.pinpointemail.model.PutEmailIdentityFeedbackAttributesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putEmailIdentityFeedbackAttributes(request))
  def listTagsForResource(
      request: zio.aws.pinpointemail.model.ListTagsForResourceRequest
  ): ZIO[
    zio.aws.pinpointemail.PinpointEmail,
    AwsError,
    zio.aws.pinpointemail.model.ListTagsForResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTagsForResource(request))
  def deleteDedicatedIpPool(
      request: zio.aws.pinpointemail.model.DeleteDedicatedIpPoolRequest
  ): ZIO[
    zio.aws.pinpointemail.PinpointEmail,
    AwsError,
    zio.aws.pinpointemail.model.DeleteDedicatedIpPoolResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteDedicatedIpPool(request))
  def getDedicatedIp(
      request: zio.aws.pinpointemail.model.GetDedicatedIpRequest
  ): ZIO[
    zio.aws.pinpointemail.PinpointEmail,
    AwsError,
    zio.aws.pinpointemail.model.GetDedicatedIpResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getDedicatedIp(request))
  def putDeliverabilityDashboardOption(
      request: zio.aws.pinpointemail.model.PutDeliverabilityDashboardOptionRequest
  ): ZIO[
    zio.aws.pinpointemail.PinpointEmail,
    AwsError,
    zio.aws.pinpointemail.model.PutDeliverabilityDashboardOptionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putDeliverabilityDashboardOption(request))
  def tagResource(request: zio.aws.pinpointemail.model.TagResourceRequest): ZIO[
    zio.aws.pinpointemail.PinpointEmail,
    AwsError,
    zio.aws.pinpointemail.model.TagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.tagResource(request))
  def deleteConfigurationSet(
      request: zio.aws.pinpointemail.model.DeleteConfigurationSetRequest
  ): ZIO[
    zio.aws.pinpointemail.PinpointEmail,
    AwsError,
    zio.aws.pinpointemail.model.DeleteConfigurationSetResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteConfigurationSet(request))
  def createConfigurationSet(
      request: zio.aws.pinpointemail.model.CreateConfigurationSetRequest
  ): ZIO[
    zio.aws.pinpointemail.PinpointEmail,
    AwsError,
    zio.aws.pinpointemail.model.CreateConfigurationSetResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createConfigurationSet(request))
  def listDeliverabilityTestReports(
      request: zio.aws.pinpointemail.model.ListDeliverabilityTestReportsRequest
  ): ZStream[
    zio.aws.pinpointemail.PinpointEmail,
    AwsError,
    zio.aws.pinpointemail.model.DeliverabilityTestReport.ReadOnly
  ] = ZStream.serviceWithStream(_.listDeliverabilityTestReports(request))
  def listDeliverabilityTestReportsPaginated(
      request: zio.aws.pinpointemail.model.ListDeliverabilityTestReportsRequest
  ): ZIO[
    zio.aws.pinpointemail.PinpointEmail,
    AwsError,
    zio.aws.pinpointemail.model.ListDeliverabilityTestReportsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listDeliverabilityTestReportsPaginated(request))
  def updateConfigurationSetEventDestination(
      request: zio.aws.pinpointemail.model.UpdateConfigurationSetEventDestinationRequest
  ): ZIO[
    zio.aws.pinpointemail.PinpointEmail,
    AwsError,
    zio.aws.pinpointemail.model.UpdateConfigurationSetEventDestinationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateConfigurationSetEventDestination(request))
  def putDedicatedIpInPool(
      request: zio.aws.pinpointemail.model.PutDedicatedIpInPoolRequest
  ): ZIO[
    zio.aws.pinpointemail.PinpointEmail,
    AwsError,
    zio.aws.pinpointemail.model.PutDedicatedIpInPoolResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putDedicatedIpInPool(request))
  def putConfigurationSetSendingOptions(
      request: zio.aws.pinpointemail.model.PutConfigurationSetSendingOptionsRequest
  ): ZIO[
    zio.aws.pinpointemail.PinpointEmail,
    AwsError,
    zio.aws.pinpointemail.model.PutConfigurationSetSendingOptionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putConfigurationSetSendingOptions(request))
  def putConfigurationSetDeliveryOptions(
      request: zio.aws.pinpointemail.model.PutConfigurationSetDeliveryOptionsRequest
  ): ZIO[
    zio.aws.pinpointemail.PinpointEmail,
    AwsError,
    zio.aws.pinpointemail.model.PutConfigurationSetDeliveryOptionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putConfigurationSetDeliveryOptions(request))
  def getDeliverabilityTestReport(
      request: zio.aws.pinpointemail.model.GetDeliverabilityTestReportRequest
  ): ZIO[
    zio.aws.pinpointemail.PinpointEmail,
    AwsError,
    zio.aws.pinpointemail.model.GetDeliverabilityTestReportResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getDeliverabilityTestReport(request))
  def putDedicatedIpWarmupAttributes(
      request: zio.aws.pinpointemail.model.PutDedicatedIpWarmupAttributesRequest
  ): ZIO[
    zio.aws.pinpointemail.PinpointEmail,
    AwsError,
    zio.aws.pinpointemail.model.PutDedicatedIpWarmupAttributesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putDedicatedIpWarmupAttributes(request))
  def deleteConfigurationSetEventDestination(
      request: zio.aws.pinpointemail.model.DeleteConfigurationSetEventDestinationRequest
  ): ZIO[
    zio.aws.pinpointemail.PinpointEmail,
    AwsError,
    zio.aws.pinpointemail.model.DeleteConfigurationSetEventDestinationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteConfigurationSetEventDestination(request))
  def putEmailIdentityDkimAttributes(
      request: zio.aws.pinpointemail.model.PutEmailIdentityDkimAttributesRequest
  ): ZIO[
    zio.aws.pinpointemail.PinpointEmail,
    AwsError,
    zio.aws.pinpointemail.model.PutEmailIdentityDkimAttributesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putEmailIdentityDkimAttributes(request))
}
