package zio.aws.pinpointemail.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpointemail.model.primitives.{Enabled, Identity}
import scala.jdk.CollectionConverters.*
final case class PutEmailIdentityDkimAttributesRequest(
    emailIdentity: Identity,
    signingEnabled: Option[Enabled] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpointemail.model.PutEmailIdentityDkimAttributesRequest = {
    import PutEmailIdentityDkimAttributesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpointemail.model.PutEmailIdentityDkimAttributesRequest
      .builder()
      .emailIdentity(Identity.unwrap(emailIdentity): java.lang.String)
      .optionallyWith(
        signingEnabled.map(value => Enabled.unwrap(value): java.lang.Boolean)
      )(_.signingEnabled)
      .build()
  }
  def asReadOnly
      : zio.aws.pinpointemail.model.PutEmailIdentityDkimAttributesRequest.ReadOnly =
    zio.aws.pinpointemail.model.PutEmailIdentityDkimAttributesRequest
      .wrap(buildAwsValue())
}
object PutEmailIdentityDkimAttributesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpointemail.model.PutEmailIdentityDkimAttributesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.pinpointemail.model.PutEmailIdentityDkimAttributesRequest =
      zio.aws.pinpointemail.model.PutEmailIdentityDkimAttributesRequest(
        emailIdentity,
        signingEnabled.map(value => value)
      )
    def emailIdentity: Identity
    def signingEnabled: Option[Enabled]
    def getEmailIdentity: ZIO[Any, Nothing, Identity] =
      ZIO.succeed(emailIdentity)
    def getSigningEnabled: ZIO[Any, AwsError, Enabled] =
      AwsError.unwrapOptionField("signingEnabled", signingEnabled)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpointemail.model.PutEmailIdentityDkimAttributesRequest
  ) extends zio.aws.pinpointemail.model.PutEmailIdentityDkimAttributesRequest.ReadOnly {
    override val emailIdentity: Identity =
      zio.aws.pinpointemail.model.primitives.Identity(impl.emailIdentity())
    override val signingEnabled: Option[Enabled] = scala
      .Option(impl.signingEnabled())
      .map(value => zio.aws.pinpointemail.model.primitives.Enabled(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpointemail.model.PutEmailIdentityDkimAttributesRequest
  ): zio.aws.pinpointemail.model.PutEmailIdentityDkimAttributesRequest.ReadOnly =
    new Wrapper(impl)
}
