package zio.aws.pinpointemail.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpointemail.model.primitives.Enabled
import scala.jdk.CollectionConverters.*
final case class PutAccountDedicatedIpWarmupAttributesRequest(
    autoWarmupEnabled: Option[Enabled] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpointemail.model.PutAccountDedicatedIpWarmupAttributesRequest = {
    import PutAccountDedicatedIpWarmupAttributesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpointemail.model.PutAccountDedicatedIpWarmupAttributesRequest
      .builder()
      .optionallyWith(
        autoWarmupEnabled.map(value => Enabled.unwrap(value): java.lang.Boolean)
      )(_.autoWarmupEnabled)
      .build()
  }
  def asReadOnly
      : zio.aws.pinpointemail.model.PutAccountDedicatedIpWarmupAttributesRequest.ReadOnly =
    zio.aws.pinpointemail.model.PutAccountDedicatedIpWarmupAttributesRequest
      .wrap(buildAwsValue())
}
object PutAccountDedicatedIpWarmupAttributesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpointemail.model.PutAccountDedicatedIpWarmupAttributesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.pinpointemail.model.PutAccountDedicatedIpWarmupAttributesRequest =
      zio.aws.pinpointemail.model.PutAccountDedicatedIpWarmupAttributesRequest(
        autoWarmupEnabled.map(value => value)
      )
    def autoWarmupEnabled: Option[Enabled]
    def getAutoWarmupEnabled: ZIO[Any, AwsError, Enabled] =
      AwsError.unwrapOptionField("autoWarmupEnabled", autoWarmupEnabled)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpointemail.model.PutAccountDedicatedIpWarmupAttributesRequest
  ) extends zio.aws.pinpointemail.model.PutAccountDedicatedIpWarmupAttributesRequest.ReadOnly {
    override val autoWarmupEnabled: Option[Enabled] = scala
      .Option(impl.autoWarmupEnabled())
      .map(value => zio.aws.pinpointemail.model.primitives.Enabled(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpointemail.model.PutAccountDedicatedIpWarmupAttributesRequest
  ): zio.aws.pinpointemail.model.PutAccountDedicatedIpWarmupAttributesRequest.ReadOnly =
    new Wrapper(impl)
}
