package zio.aws.pinpointemail
import zio.aws.pinpointemail.model.primitives.MessageData.Type
import java.time.Instant
import zio.aws.pinpointemail.model.primitives.{
  EmailAddress,
  PoolName,
  BlacklistItemName,
  ConfigurationSetName,
  Ip,
  Esp,
  DnsToken,
  IspName,
  TagKey
}
import zio.Chunk
import zio.prelude.Subtype
package object model {
  import scala.jdk.CollectionConverters._
  object primitives {
    object AmazonResourceName extends Subtype[String]
    type AmazonResourceName =
      zio.aws.pinpointemail.model.primitives.AmazonResourceName.Type
    object BlacklistItemName extends Subtype[String]
    type BlacklistItemName =
      zio.aws.pinpointemail.model.primitives.BlacklistItemName.Type
    object BlacklistingDescription extends Subtype[String]
    type BlacklistingDescription =
      zio.aws.pinpointemail.model.primitives.BlacklistingDescription.Type
    object CampaignId extends Subtype[String]
    type CampaignId = zio.aws.pinpointemail.model.primitives.CampaignId.Type
    object Charset extends Subtype[String]
    type Charset = zio.aws.pinpointemail.model.primitives.Charset.Type
    object ConfigurationSetName extends Subtype[String]
    type ConfigurationSetName =
      zio.aws.pinpointemail.model.primitives.ConfigurationSetName.Type
    object CustomRedirectDomain extends Subtype[String]
    type CustomRedirectDomain =
      zio.aws.pinpointemail.model.primitives.CustomRedirectDomain.Type
    object DefaultDimensionValue extends Subtype[String]
    type DefaultDimensionValue =
      zio.aws.pinpointemail.model.primitives.DefaultDimensionValue.Type
    object DeliverabilityTestSubject extends Subtype[String]
    type DeliverabilityTestSubject =
      zio.aws.pinpointemail.model.primitives.DeliverabilityTestSubject.Type
    object DimensionName extends Subtype[String]
    type DimensionName =
      zio.aws.pinpointemail.model.primitives.DimensionName.Type
    object DnsToken extends Subtype[String]
    type DnsToken = zio.aws.pinpointemail.model.primitives.DnsToken.Type
    object Domain extends Subtype[String]
    type Domain = zio.aws.pinpointemail.model.primitives.Domain.Type
    object EmailAddress extends Subtype[String]
    type EmailAddress = zio.aws.pinpointemail.model.primitives.EmailAddress.Type
    object Enabled extends Subtype[Boolean]
    type Enabled = zio.aws.pinpointemail.model.primitives.Enabled.Type
    object Esp extends Subtype[String]
    type Esp = zio.aws.pinpointemail.model.primitives.Esp.Type
    object EventDestinationName extends Subtype[String]
    type EventDestinationName =
      zio.aws.pinpointemail.model.primitives.EventDestinationName.Type
    object GeneralEnforcementStatus extends Subtype[String]
    type GeneralEnforcementStatus =
      zio.aws.pinpointemail.model.primitives.GeneralEnforcementStatus.Type
    object Identity extends Subtype[String]
    type Identity = zio.aws.pinpointemail.model.primitives.Identity.Type
    object ImageUrl extends Subtype[String]
    type ImageUrl = zio.aws.pinpointemail.model.primitives.ImageUrl.Type
    object Ip extends Subtype[String]
    type Ip = zio.aws.pinpointemail.model.primitives.Ip.Type
    object IspName extends Subtype[String]
    type IspName = zio.aws.pinpointemail.model.primitives.IspName.Type
    object LastFreshStart extends Subtype[Instant]
    type LastFreshStart =
      zio.aws.pinpointemail.model.primitives.LastFreshStart.Type
    object MailFromDomainName extends Subtype[String]
    type MailFromDomainName =
      zio.aws.pinpointemail.model.primitives.MailFromDomainName.Type
    object Max24HourSend extends Subtype[Double]
    type Max24HourSend =
      zio.aws.pinpointemail.model.primitives.Max24HourSend.Type
    object MaxItems extends Subtype[Int]
    type MaxItems = zio.aws.pinpointemail.model.primitives.MaxItems.Type
    object MaxSendRate extends Subtype[Double]
    type MaxSendRate = zio.aws.pinpointemail.model.primitives.MaxSendRate.Type
    object MessageContent extends Subtype[String]
    type MessageContent =
      zio.aws.pinpointemail.model.primitives.MessageContent.Type
    object MessageData extends Subtype[String]
    type MessageData = zio.aws.pinpointemail.model.primitives.MessageData.Type
    object MessageTagName extends Subtype[String]
    type MessageTagName =
      zio.aws.pinpointemail.model.primitives.MessageTagName.Type
    object MessageTagValue extends Subtype[String]
    type MessageTagValue =
      zio.aws.pinpointemail.model.primitives.MessageTagValue.Type
    object NextToken extends Subtype[String]
    type NextToken = zio.aws.pinpointemail.model.primitives.NextToken.Type
    object OutboundMessageId extends Subtype[String]
    type OutboundMessageId =
      zio.aws.pinpointemail.model.primitives.OutboundMessageId.Type
    object Percentage extends Subtype[Double]
    type Percentage = zio.aws.pinpointemail.model.primitives.Percentage.Type
    object Percentage100Wrapper extends Subtype[Int]
    type Percentage100Wrapper =
      zio.aws.pinpointemail.model.primitives.Percentage100Wrapper.Type
    object PoolName extends Subtype[String]
    type PoolName = zio.aws.pinpointemail.model.primitives.PoolName.Type
    object RawMessageData extends Subtype[Chunk[Byte]]
    type RawMessageData =
      zio.aws.pinpointemail.model.primitives.RawMessageData.Type
    object RblName extends Subtype[String]
    type RblName = zio.aws.pinpointemail.model.primitives.RblName.Type
    object ReportId extends Subtype[String]
    type ReportId = zio.aws.pinpointemail.model.primitives.ReportId.Type
    object ReportName extends Subtype[String]
    type ReportName = zio.aws.pinpointemail.model.primitives.ReportName.Type
    object SendingPoolName extends Subtype[String]
    type SendingPoolName =
      zio.aws.pinpointemail.model.primitives.SendingPoolName.Type
    object SentLast24Hours extends Subtype[Double]
    type SentLast24Hours =
      zio.aws.pinpointemail.model.primitives.SentLast24Hours.Type
    object Subject extends Subtype[String]
    type Subject = zio.aws.pinpointemail.model.primitives.Subject.Type
    object TagKey extends Subtype[String]
    type TagKey = zio.aws.pinpointemail.model.primitives.TagKey.Type
    object TagValue extends Subtype[String]
    type TagValue = zio.aws.pinpointemail.model.primitives.TagValue.Type
    object TemplateArn extends Subtype[String]
    type TemplateArn = zio.aws.pinpointemail.model.primitives.TemplateArn.Type
    object TemplateData extends Subtype[String]
    type TemplateData = zio.aws.pinpointemail.model.primitives.TemplateData.Type
    object Timestamp extends Subtype[Instant]
    type Timestamp = zio.aws.pinpointemail.model.primitives.Timestamp.Type
    object Volume extends Subtype[Long]
    type Volume = zio.aws.pinpointemail.model.primitives.Volume.Type
  }
  type BlacklistEntries = List[zio.aws.pinpointemail.model.BlacklistEntry]
  type BlacklistItemNames = List[BlacklistItemName]
  type BlacklistReport =
    Map[BlacklistItemName, Iterable[zio.aws.pinpointemail.model.BlacklistEntry]]
  type CloudWatchDimensionConfigurations =
    List[zio.aws.pinpointemail.model.CloudWatchDimensionConfiguration]
  type ConfigurationSetNameList = List[ConfigurationSetName]
  type DailyVolumes = List[zio.aws.pinpointemail.model.DailyVolume]
  type DedicatedIpList = List[zio.aws.pinpointemail.model.DedicatedIp]
  type DeliverabilityTestReports =
    List[zio.aws.pinpointemail.model.DeliverabilityTestReport]
  type DnsTokenList = List[DnsToken]
  type DomainDeliverabilityCampaignList =
    List[zio.aws.pinpointemail.model.DomainDeliverabilityCampaign]
  type DomainDeliverabilityTrackingOptions =
    List[zio.aws.pinpointemail.model.DomainDeliverabilityTrackingOption]
  type DomainIspPlacements =
    List[zio.aws.pinpointemail.model.DomainIspPlacement]
  type EmailAddressList = List[EmailAddress]
  type Esps = List[Esp]
  type EventDestinations = List[zio.aws.pinpointemail.model.EventDestination]
  type EventTypes = List[zio.aws.pinpointemail.model.EventType]
  type IdentityInfoList = List[zio.aws.pinpointemail.model.IdentityInfo]
  type IpList = List[Ip]
  type IspNameList = List[IspName]
  type IspPlacements = List[zio.aws.pinpointemail.model.IspPlacement]
  type ListOfDedicatedIpPools = List[PoolName]
  type MessageTagList = List[zio.aws.pinpointemail.model.MessageTag]
  type TagKeyList = List[TagKey]
  type TagList = List[zio.aws.pinpointemail.model.Tag]
}
