package zio.aws.pinpointemail.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.pinpointemail.model.primitives.{LastFreshStart, Enabled}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class ReputationOptions(
    reputationMetricsEnabled: Optional[Enabled] = Optional.Absent,
    lastFreshStart: Optional[LastFreshStart] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpointemail.model.ReputationOptions = {
    import ReputationOptions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpointemail.model.ReputationOptions
      .builder()
      .optionallyWith(
        reputationMetricsEnabled.map(value =>
          Enabled.unwrap(value): java.lang.Boolean
        )
      )(_.reputationMetricsEnabled)
      .optionallyWith(
        lastFreshStart.map(value => LastFreshStart.unwrap(value): Instant)
      )(_.lastFreshStart)
      .build()
  }
  def asReadOnly: zio.aws.pinpointemail.model.ReputationOptions.ReadOnly =
    zio.aws.pinpointemail.model.ReputationOptions.wrap(buildAwsValue())
}
object ReputationOptions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpointemail.model.ReputationOptions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpointemail.model.ReputationOptions =
      zio.aws.pinpointemail.model.ReputationOptions(
        reputationMetricsEnabled.map(value => value),
        lastFreshStart.map(value => value)
      )
    def reputationMetricsEnabled: Optional[Enabled]
    def lastFreshStart: Optional[LastFreshStart]
    def getReputationMetricsEnabled: ZIO[Any, AwsError, Enabled] = AwsError
      .unwrapOptionField("reputationMetricsEnabled", reputationMetricsEnabled)
    def getLastFreshStart: ZIO[Any, AwsError, LastFreshStart] =
      AwsError.unwrapOptionField("lastFreshStart", lastFreshStart)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpointemail.model.ReputationOptions
  ) extends zio.aws.pinpointemail.model.ReputationOptions.ReadOnly {
    override val reputationMetricsEnabled: Optional[Enabled] =
      zio.aws.core.internal
        .optionalFromNullable(impl.reputationMetricsEnabled())
        .map(value => zio.aws.pinpointemail.model.primitives.Enabled(value))
    override val lastFreshStart: Optional[LastFreshStart] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastFreshStart())
        .map(value =>
          zio.aws.pinpointemail.model.primitives.LastFreshStart(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpointemail.model.ReputationOptions
  ): zio.aws.pinpointemail.model.ReputationOptions.ReadOnly = new Wrapper(impl)
}
