package zio.aws.pinpointemail.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpointemail.model.primitives.MessageContent
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetDeliverabilityTestReportResponse(
    deliverabilityTestReport: zio.aws.pinpointemail.model.DeliverabilityTestReport,
    overallPlacement: zio.aws.pinpointemail.model.PlacementStatistics,
    ispPlacements: Iterable[zio.aws.pinpointemail.model.IspPlacement],
    message: Optional[MessageContent] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.pinpointemail.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpointemail.model.GetDeliverabilityTestReportResponse = {
    import GetDeliverabilityTestReportResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpointemail.model.GetDeliverabilityTestReportResponse
      .builder()
      .deliverabilityTestReport(deliverabilityTestReport.buildAwsValue())
      .overallPlacement(overallPlacement.buildAwsValue())
      .ispPlacements(ispPlacements.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        message.map(value => MessageContent.unwrap(value): java.lang.String)
      )(_.message)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.pinpointemail.model.GetDeliverabilityTestReportResponse.ReadOnly =
    zio.aws.pinpointemail.model.GetDeliverabilityTestReportResponse
      .wrap(buildAwsValue())
}
object GetDeliverabilityTestReportResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpointemail.model.GetDeliverabilityTestReportResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.pinpointemail.model.GetDeliverabilityTestReportResponse =
      zio.aws.pinpointemail.model.GetDeliverabilityTestReportResponse(
        deliverabilityTestReport.asEditable,
        overallPlacement.asEditable,
        ispPlacements.map { item =>
          item.asEditable
        },
        message.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def deliverabilityTestReport
        : zio.aws.pinpointemail.model.DeliverabilityTestReport.ReadOnly
    def overallPlacement
        : zio.aws.pinpointemail.model.PlacementStatistics.ReadOnly
    def ispPlacements: List[zio.aws.pinpointemail.model.IspPlacement.ReadOnly]
    def message: Optional[MessageContent]
    def tags: Optional[List[zio.aws.pinpointemail.model.Tag.ReadOnly]]
    def getDeliverabilityTestReport: ZIO[
      Any,
      Nothing,
      zio.aws.pinpointemail.model.DeliverabilityTestReport.ReadOnly
    ] = ZIO.succeed(deliverabilityTestReport)
    def getOverallPlacement: ZIO[
      Any,
      Nothing,
      zio.aws.pinpointemail.model.PlacementStatistics.ReadOnly
    ] = ZIO.succeed(overallPlacement)
    def getIspPlacements: ZIO[Any, Nothing, List[
      zio.aws.pinpointemail.model.IspPlacement.ReadOnly
    ]] = ZIO.succeed(ispPlacements)
    def getMessage: ZIO[Any, AwsError, MessageContent] =
      AwsError.unwrapOptionField("message", message)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.pinpointemail.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpointemail.model.GetDeliverabilityTestReportResponse
  ) extends zio.aws.pinpointemail.model.GetDeliverabilityTestReportResponse.ReadOnly {
    override val deliverabilityTestReport
        : zio.aws.pinpointemail.model.DeliverabilityTestReport.ReadOnly =
      zio.aws.pinpointemail.model.DeliverabilityTestReport
        .wrap(impl.deliverabilityTestReport())
    override val overallPlacement
        : zio.aws.pinpointemail.model.PlacementStatistics.ReadOnly =
      zio.aws.pinpointemail.model.PlacementStatistics
        .wrap(impl.overallPlacement())
    override val ispPlacements
        : List[zio.aws.pinpointemail.model.IspPlacement.ReadOnly] = impl
      .ispPlacements()
      .asScala
      .map { item =>
        zio.aws.pinpointemail.model.IspPlacement.wrap(item)
      }
      .toList
    override val message: Optional[MessageContent] = zio.aws.core.internal
      .optionalFromNullable(impl.message())
      .map(value =>
        zio.aws.pinpointemail.model.primitives.MessageContent(value)
      )
    override val tags
        : Optional[List[zio.aws.pinpointemail.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.pinpointemail.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpointemail.model.GetDeliverabilityTestReportResponse
  ): zio.aws.pinpointemail.model.GetDeliverabilityTestReportResponse.ReadOnly =
    new Wrapper(impl)
}
