package zio.aws.pinpointemail.model
import scala.jdk.CollectionConverters._
sealed trait DimensionValueSource {
  def unwrap
      : software.amazon.awssdk.services.pinpointemail.model.DimensionValueSource
}
object DimensionValueSource {
  def wrap(
      value: software.amazon.awssdk.services.pinpointemail.model.DimensionValueSource
  ): zio.aws.pinpointemail.model.DimensionValueSource = value match {
    case software.amazon.awssdk.services.pinpointemail.model.DimensionValueSource.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.pinpointemail.model.DimensionValueSource.MESSAGE_TAG =>
      val r = MESSAGE_TAG
      r
    case software.amazon.awssdk.services.pinpointemail.model.DimensionValueSource.EMAIL_HEADER =>
      val r = EMAIL_HEADER
      r
    case software.amazon.awssdk.services.pinpointemail.model.DimensionValueSource.LINK_TAG =>
      val r = LINK_TAG
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.pinpointemail.model.DimensionValueSource {
    override def unwrap
        : software.amazon.awssdk.services.pinpointemail.model.DimensionValueSource =
      software.amazon.awssdk.services.pinpointemail.model.DimensionValueSource.UNKNOWN_TO_SDK_VERSION
  }
  case object MESSAGE_TAG
      extends zio.aws.pinpointemail.model.DimensionValueSource {
    override def unwrap
        : software.amazon.awssdk.services.pinpointemail.model.DimensionValueSource =
      software.amazon.awssdk.services.pinpointemail.model.DimensionValueSource.MESSAGE_TAG
  }
  case object EMAIL_HEADER
      extends zio.aws.pinpointemail.model.DimensionValueSource {
    override def unwrap
        : software.amazon.awssdk.services.pinpointemail.model.DimensionValueSource =
      software.amazon.awssdk.services.pinpointemail.model.DimensionValueSource.EMAIL_HEADER
  }
  case object LINK_TAG
      extends zio.aws.pinpointemail.model.DimensionValueSource {
    override def unwrap
        : software.amazon.awssdk.services.pinpointemail.model.DimensionValueSource =
      software.amazon.awssdk.services.pinpointemail.model.DimensionValueSource.LINK_TAG
  }
}
