package zio.aws.pinpointemail.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpointemail.model.primitives.Identity
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateEmailIdentityRequest(
    emailIdentity: Identity,
    tags: Optional[Iterable[zio.aws.pinpointemail.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpointemail.model.CreateEmailIdentityRequest = {
    import CreateEmailIdentityRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpointemail.model.CreateEmailIdentityRequest
      .builder()
      .emailIdentity(Identity.unwrap(emailIdentity): java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.pinpointemail.model.CreateEmailIdentityRequest.ReadOnly =
    zio.aws.pinpointemail.model.CreateEmailIdentityRequest.wrap(buildAwsValue())
}
object CreateEmailIdentityRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpointemail.model.CreateEmailIdentityRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpointemail.model.CreateEmailIdentityRequest =
      zio.aws.pinpointemail.model.CreateEmailIdentityRequest(
        emailIdentity,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def emailIdentity: Identity
    def tags: Optional[List[zio.aws.pinpointemail.model.Tag.ReadOnly]]
    def getEmailIdentity: ZIO[Any, Nothing, Identity] =
      ZIO.succeed(emailIdentity)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.pinpointemail.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpointemail.model.CreateEmailIdentityRequest
  ) extends zio.aws.pinpointemail.model.CreateEmailIdentityRequest.ReadOnly {
    override val emailIdentity: Identity =
      zio.aws.pinpointemail.model.primitives.Identity(impl.emailIdentity())
    override val tags
        : Optional[List[zio.aws.pinpointemail.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.pinpointemail.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpointemail.model.CreateEmailIdentityRequest
  ): zio.aws.pinpointemail.model.CreateEmailIdentityRequest.ReadOnly =
    new Wrapper(impl)
}
