package zio.aws.pinpointemail.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.pinpointemail.model.primitives.{
  EventDestinationName,
  ConfigurationSetName
}
import scala.jdk.CollectionConverters._
final case class CreateConfigurationSetEventDestinationRequest(
    configurationSetName: ConfigurationSetName,
    eventDestinationName: EventDestinationName,
    eventDestination: zio.aws.pinpointemail.model.EventDestinationDefinition
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpointemail.model.CreateConfigurationSetEventDestinationRequest = {
    import CreateConfigurationSetEventDestinationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpointemail.model.CreateConfigurationSetEventDestinationRequest
      .builder()
      .configurationSetName(
        ConfigurationSetName.unwrap(configurationSetName): java.lang.String
      )
      .eventDestinationName(
        EventDestinationName.unwrap(eventDestinationName): java.lang.String
      )
      .eventDestination(eventDestination.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.pinpointemail.model.CreateConfigurationSetEventDestinationRequest.ReadOnly =
    zio.aws.pinpointemail.model.CreateConfigurationSetEventDestinationRequest
      .wrap(buildAwsValue())
}
object CreateConfigurationSetEventDestinationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpointemail.model.CreateConfigurationSetEventDestinationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.pinpointemail.model.CreateConfigurationSetEventDestinationRequest =
      zio.aws.pinpointemail.model.CreateConfigurationSetEventDestinationRequest(
        configurationSetName,
        eventDestinationName,
        eventDestination.asEditable
      )
    def configurationSetName: ConfigurationSetName
    def eventDestinationName: EventDestinationName
    def eventDestination
        : zio.aws.pinpointemail.model.EventDestinationDefinition.ReadOnly
    def getConfigurationSetName: ZIO[Any, Nothing, ConfigurationSetName] =
      ZIO.succeed(configurationSetName)
    def getEventDestinationName: ZIO[Any, Nothing, EventDestinationName] =
      ZIO.succeed(eventDestinationName)
    def getEventDestination: ZIO[
      Any,
      Nothing,
      zio.aws.pinpointemail.model.EventDestinationDefinition.ReadOnly
    ] = ZIO.succeed(eventDestination)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpointemail.model.CreateConfigurationSetEventDestinationRequest
  ) extends zio.aws.pinpointemail.model.CreateConfigurationSetEventDestinationRequest.ReadOnly {
    override val configurationSetName: ConfigurationSetName =
      zio.aws.pinpointemail.model.primitives
        .ConfigurationSetName(impl.configurationSetName())
    override val eventDestinationName: EventDestinationName =
      zio.aws.pinpointemail.model.primitives
        .EventDestinationName(impl.eventDestinationName())
    override val eventDestination
        : zio.aws.pinpointemail.model.EventDestinationDefinition.ReadOnly =
      zio.aws.pinpointemail.model.EventDestinationDefinition
        .wrap(impl.eventDestination())
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpointemail.model.CreateConfigurationSetEventDestinationRequest
  ): zio.aws.pinpointemail.model.CreateConfigurationSetEventDestinationRequest.ReadOnly =
    new Wrapper(impl)
}
