package zio.aws.pinpointemail.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.pinpointemail.model.primitives.{
  MaxItems,
  NextToken,
  Domain,
  Timestamp
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListDomainDeliverabilityCampaignsRequest(
    startDate: Timestamp,
    endDate: Timestamp,
    subscribedDomain: Domain,
    nextToken: Optional[NextToken] = Optional.Absent,
    pageSize: Optional[MaxItems] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpointemail.model.ListDomainDeliverabilityCampaignsRequest = {
    import ListDomainDeliverabilityCampaignsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpointemail.model.ListDomainDeliverabilityCampaignsRequest
      .builder()
      .startDate(Timestamp.unwrap(startDate): Instant)
      .endDate(Timestamp.unwrap(endDate): Instant)
      .subscribedDomain(Domain.unwrap(subscribedDomain): java.lang.String)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(pageSize.map(value => MaxItems.unwrap(value): Integer))(
        _.pageSize
      )
      .build()
  }
  def asReadOnly
      : zio.aws.pinpointemail.model.ListDomainDeliverabilityCampaignsRequest.ReadOnly =
    zio.aws.pinpointemail.model.ListDomainDeliverabilityCampaignsRequest
      .wrap(buildAwsValue())
}
object ListDomainDeliverabilityCampaignsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpointemail.model.ListDomainDeliverabilityCampaignsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.pinpointemail.model.ListDomainDeliverabilityCampaignsRequest =
      zio.aws.pinpointemail.model.ListDomainDeliverabilityCampaignsRequest(
        startDate,
        endDate,
        subscribedDomain,
        nextToken.map(value => value),
        pageSize.map(value => value)
      )
    def startDate: Timestamp
    def endDate: Timestamp
    def subscribedDomain: Domain
    def nextToken: Optional[NextToken]
    def pageSize: Optional[MaxItems]
    def getStartDate: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(startDate)
    def getEndDate: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(endDate)
    def getSubscribedDomain: ZIO[Any, Nothing, Domain] =
      ZIO.succeed(subscribedDomain)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getPageSize: ZIO[Any, AwsError, MaxItems] =
      AwsError.unwrapOptionField("pageSize", pageSize)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpointemail.model.ListDomainDeliverabilityCampaignsRequest
  ) extends zio.aws.pinpointemail.model.ListDomainDeliverabilityCampaignsRequest.ReadOnly {
    override val startDate: Timestamp =
      zio.aws.pinpointemail.model.primitives.Timestamp(impl.startDate())
    override val endDate: Timestamp =
      zio.aws.pinpointemail.model.primitives.Timestamp(impl.endDate())
    override val subscribedDomain: Domain =
      zio.aws.pinpointemail.model.primitives.Domain(impl.subscribedDomain())
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.pinpointemail.model.primitives.NextToken(value))
    override val pageSize: Optional[MaxItems] = zio.aws.core.internal
      .optionalFromNullable(impl.pageSize())
      .map(value => zio.aws.pinpointemail.model.primitives.MaxItems(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpointemail.model.ListDomainDeliverabilityCampaignsRequest
  ): zio.aws.pinpointemail.model.ListDomainDeliverabilityCampaignsRequest.ReadOnly =
    new Wrapper(impl)
}
