package zio.aws.pinpointemail.model
import zio.prelude.data.Optional
import zio.aws.pinpointemail.model.primitives.{
  PoolName,
  Percentage100Wrapper,
  Ip
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class DedicatedIp(
    ip: Ip,
    warmupStatus: zio.aws.pinpointemail.model.WarmupStatus,
    warmupPercentage: Percentage100Wrapper,
    poolName: Optional[PoolName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpointemail.model.DedicatedIp = {
    import DedicatedIp.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpointemail.model.DedicatedIp
      .builder()
      .ip(Ip.unwrap(ip): java.lang.String)
      .warmupStatus(warmupStatus.unwrap)
      .warmupPercentage(Percentage100Wrapper.unwrap(warmupPercentage): Integer)
      .optionallyWith(
        poolName.map(value => PoolName.unwrap(value): java.lang.String)
      )(_.poolName)
      .build()
  }
  def asReadOnly: zio.aws.pinpointemail.model.DedicatedIp.ReadOnly =
    zio.aws.pinpointemail.model.DedicatedIp.wrap(buildAwsValue())
}
object DedicatedIp {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpointemail.model.DedicatedIp
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpointemail.model.DedicatedIp =
      zio.aws.pinpointemail.model.DedicatedIp(
        ip,
        warmupStatus,
        warmupPercentage,
        poolName.map(value => value)
      )
    def ip: Ip
    def warmupStatus: zio.aws.pinpointemail.model.WarmupStatus
    def warmupPercentage: Percentage100Wrapper
    def poolName: Optional[PoolName]
    def getIp: ZIO[Any, Nothing, Ip] = ZIO.succeed(ip)
    def getWarmupStatus
        : ZIO[Any, Nothing, zio.aws.pinpointemail.model.WarmupStatus] =
      ZIO.succeed(warmupStatus)
    def getWarmupPercentage: ZIO[Any, Nothing, Percentage100Wrapper] =
      ZIO.succeed(warmupPercentage)
    def getPoolName: ZIO[Any, AwsError, PoolName] =
      AwsError.unwrapOptionField("poolName", poolName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpointemail.model.DedicatedIp
  ) extends zio.aws.pinpointemail.model.DedicatedIp.ReadOnly {
    override val ip: Ip = zio.aws.pinpointemail.model.primitives.Ip(impl.ip())
    override val warmupStatus: zio.aws.pinpointemail.model.WarmupStatus =
      zio.aws.pinpointemail.model.WarmupStatus.wrap(impl.warmupStatus())
    override val warmupPercentage: Percentage100Wrapper =
      zio.aws.pinpointemail.model.primitives
        .Percentage100Wrapper(impl.warmupPercentage())
    override val poolName: Optional[PoolName] = zio.aws.core.internal
      .optionalFromNullable(impl.poolName())
      .map(value => zio.aws.pinpointemail.model.primitives.PoolName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpointemail.model.DedicatedIp
  ): zio.aws.pinpointemail.model.DedicatedIp.ReadOnly = new Wrapper(impl)
}
