package zio.aws.pinpointemail.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class CloudWatchDestination(
    dimensionConfigurations: Iterable[
      zio.aws.pinpointemail.model.CloudWatchDimensionConfiguration
    ]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpointemail.model.CloudWatchDestination = {
    import CloudWatchDestination.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpointemail.model.CloudWatchDestination
      .builder()
      .dimensionConfigurations(dimensionConfigurations.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.pinpointemail.model.CloudWatchDestination.ReadOnly =
    zio.aws.pinpointemail.model.CloudWatchDestination.wrap(buildAwsValue())
}
object CloudWatchDestination {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpointemail.model.CloudWatchDestination
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpointemail.model.CloudWatchDestination =
      zio.aws.pinpointemail.model
        .CloudWatchDestination(dimensionConfigurations.map { item =>
          item.asEditable
        })
    def dimensionConfigurations: List[
      zio.aws.pinpointemail.model.CloudWatchDimensionConfiguration.ReadOnly
    ]
    def getDimensionConfigurations: ZIO[Any, Nothing, List[
      zio.aws.pinpointemail.model.CloudWatchDimensionConfiguration.ReadOnly
    ]] = ZIO.succeed(dimensionConfigurations)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpointemail.model.CloudWatchDestination
  ) extends zio.aws.pinpointemail.model.CloudWatchDestination.ReadOnly {
    override val dimensionConfigurations: List[
      zio.aws.pinpointemail.model.CloudWatchDimensionConfiguration.ReadOnly
    ] = impl
      .dimensionConfigurations()
      .asScala
      .map { item =>
        zio.aws.pinpointemail.model.CloudWatchDimensionConfiguration.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpointemail.model.CloudWatchDestination
  ): zio.aws.pinpointemail.model.CloudWatchDestination.ReadOnly = new Wrapper(
    impl
  )
}
