package zio.aws.pinpointemail.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.pinpointemail.model.primitives.MailFromDomainName
import scala.jdk.CollectionConverters._
final case class MailFromAttributes(
    mailFromDomain: MailFromDomainName,
    mailFromDomainStatus: zio.aws.pinpointemail.model.MailFromDomainStatus,
    behaviorOnMxFailure: zio.aws.pinpointemail.model.BehaviorOnMxFailure
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpointemail.model.MailFromAttributes = {
    import MailFromAttributes.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpointemail.model.MailFromAttributes
      .builder()
      .mailFromDomain(
        MailFromDomainName.unwrap(mailFromDomain): java.lang.String
      )
      .mailFromDomainStatus(mailFromDomainStatus.unwrap)
      .behaviorOnMxFailure(behaviorOnMxFailure.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.pinpointemail.model.MailFromAttributes.ReadOnly =
    zio.aws.pinpointemail.model.MailFromAttributes.wrap(buildAwsValue())
}
object MailFromAttributes {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpointemail.model.MailFromAttributes
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpointemail.model.MailFromAttributes =
      zio.aws.pinpointemail.model.MailFromAttributes(
        mailFromDomain,
        mailFromDomainStatus,
        behaviorOnMxFailure
      )
    def mailFromDomain: MailFromDomainName
    def mailFromDomainStatus: zio.aws.pinpointemail.model.MailFromDomainStatus
    def behaviorOnMxFailure: zio.aws.pinpointemail.model.BehaviorOnMxFailure
    def getMailFromDomain: ZIO[Any, Nothing, MailFromDomainName] =
      ZIO.succeed(mailFromDomain)
    def getMailFromDomainStatus
        : ZIO[Any, Nothing, zio.aws.pinpointemail.model.MailFromDomainStatus] =
      ZIO.succeed(mailFromDomainStatus)
    def getBehaviorOnMxFailure
        : ZIO[Any, Nothing, zio.aws.pinpointemail.model.BehaviorOnMxFailure] =
      ZIO.succeed(behaviorOnMxFailure)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpointemail.model.MailFromAttributes
  ) extends zio.aws.pinpointemail.model.MailFromAttributes.ReadOnly {
    override val mailFromDomain: MailFromDomainName =
      zio.aws.pinpointemail.model.primitives
        .MailFromDomainName(impl.mailFromDomain())
    override val mailFromDomainStatus
        : zio.aws.pinpointemail.model.MailFromDomainStatus =
      zio.aws.pinpointemail.model.MailFromDomainStatus
        .wrap(impl.mailFromDomainStatus())
    override val behaviorOnMxFailure
        : zio.aws.pinpointemail.model.BehaviorOnMxFailure =
      zio.aws.pinpointemail.model.BehaviorOnMxFailure
        .wrap(impl.behaviorOnMxFailure())
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpointemail.model.MailFromAttributes
  ): zio.aws.pinpointemail.model.MailFromAttributes.ReadOnly = new Wrapper(impl)
}
