package zio.aws.pinpointemail.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.pinpointemail.model.primitives.{MessageTagValue, MessageTagName}
import scala.jdk.CollectionConverters._
final case class MessageTag(name: MessageTagName, value: MessageTagValue) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpointemail.model.MessageTag = {
    import MessageTag.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpointemail.model.MessageTag
      .builder()
      .name(MessageTagName.unwrap(name): java.lang.String)
      .value(MessageTagValue.unwrap(value): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.pinpointemail.model.MessageTag.ReadOnly =
    zio.aws.pinpointemail.model.MessageTag.wrap(buildAwsValue())
}
object MessageTag {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpointemail.model.MessageTag
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpointemail.model.MessageTag =
      zio.aws.pinpointemail.model.MessageTag(name, value)
    def name: MessageTagName
    def value: MessageTagValue
    def getName: ZIO[Any, Nothing, MessageTagName] = ZIO.succeed(name)
    def getValue: ZIO[Any, Nothing, MessageTagValue] = ZIO.succeed(value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpointemail.model.MessageTag
  ) extends zio.aws.pinpointemail.model.MessageTag.ReadOnly {
    override val name: MessageTagName =
      zio.aws.pinpointemail.model.primitives.MessageTagName(impl.name())
    override val value: MessageTagValue =
      zio.aws.pinpointemail.model.primitives.MessageTagValue(impl.value())
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpointemail.model.MessageTag
  ): zio.aws.pinpointemail.model.MessageTag.ReadOnly = new Wrapper(impl)
}
