package zio.aws.pinpointemail.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.pinpointemail.model.primitives.PoolName
import scala.jdk.CollectionConverters._
final case class DeleteDedicatedIpPoolRequest(poolName: PoolName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpointemail.model.DeleteDedicatedIpPoolRequest = {
    import DeleteDedicatedIpPoolRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpointemail.model.DeleteDedicatedIpPoolRequest
      .builder()
      .poolName(PoolName.unwrap(poolName): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.pinpointemail.model.DeleteDedicatedIpPoolRequest.ReadOnly =
    zio.aws.pinpointemail.model.DeleteDedicatedIpPoolRequest
      .wrap(buildAwsValue())
}
object DeleteDedicatedIpPoolRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpointemail.model.DeleteDedicatedIpPoolRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpointemail.model.DeleteDedicatedIpPoolRequest =
      zio.aws.pinpointemail.model.DeleteDedicatedIpPoolRequest(poolName)
    def poolName: PoolName
    def getPoolName: ZIO[Any, Nothing, PoolName] = ZIO.succeed(poolName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpointemail.model.DeleteDedicatedIpPoolRequest
  ) extends zio.aws.pinpointemail.model.DeleteDedicatedIpPoolRequest.ReadOnly {
    override val poolName: PoolName =
      zio.aws.pinpointemail.model.primitives.PoolName(impl.poolName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpointemail.model.DeleteDedicatedIpPoolRequest
  ): zio.aws.pinpointemail.model.DeleteDedicatedIpPoolRequest.ReadOnly =
    new Wrapper(impl)
}
