package zio.aws.pinpointemail.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpointemail.model.primitives.{TemplateData, TemplateArn}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Template(
    templateArn: Optional[TemplateArn] = Optional.Absent,
    templateData: Optional[TemplateData] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpointemail.model.Template = {
    import Template.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpointemail.model.Template
      .builder()
      .optionallyWith(
        templateArn.map(value => TemplateArn.unwrap(value): java.lang.String)
      )(_.templateArn)
      .optionallyWith(
        templateData.map(value => TemplateData.unwrap(value): java.lang.String)
      )(_.templateData)
      .build()
  }
  def asReadOnly: zio.aws.pinpointemail.model.Template.ReadOnly =
    zio.aws.pinpointemail.model.Template.wrap(buildAwsValue())
}
object Template {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpointemail.model.Template
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpointemail.model.Template =
      zio.aws.pinpointemail.model.Template(
        templateArn.map(value => value),
        templateData.map(value => value)
      )
    def templateArn: Optional[TemplateArn]
    def templateData: Optional[TemplateData]
    def getTemplateArn: ZIO[Any, AwsError, TemplateArn] =
      AwsError.unwrapOptionField("templateArn", templateArn)
    def getTemplateData: ZIO[Any, AwsError, TemplateData] =
      AwsError.unwrapOptionField("templateData", templateData)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpointemail.model.Template
  ) extends zio.aws.pinpointemail.model.Template.ReadOnly {
    override val templateArn: Optional[TemplateArn] = zio.aws.core.internal
      .optionalFromNullable(impl.templateArn())
      .map(value => zio.aws.pinpointemail.model.primitives.TemplateArn(value))
    override val templateData: Optional[TemplateData] = zio.aws.core.internal
      .optionalFromNullable(impl.templateData())
      .map(value => zio.aws.pinpointemail.model.primitives.TemplateData(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpointemail.model.Template
  ): zio.aws.pinpointemail.model.Template.ReadOnly = new Wrapper(impl)
}
