package zio.aws.pinpointemail.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpointemail.model.primitives.OutboundMessageId
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class SendEmailResponse(
    messageId: Optional[OutboundMessageId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpointemail.model.SendEmailResponse = {
    import SendEmailResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpointemail.model.SendEmailResponse
      .builder()
      .optionallyWith(
        messageId.map(value =>
          OutboundMessageId.unwrap(value): java.lang.String
        )
      )(_.messageId)
      .build()
  }
  def asReadOnly: zio.aws.pinpointemail.model.SendEmailResponse.ReadOnly =
    zio.aws.pinpointemail.model.SendEmailResponse.wrap(buildAwsValue())
}
object SendEmailResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpointemail.model.SendEmailResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpointemail.model.SendEmailResponse =
      zio.aws.pinpointemail.model
        .SendEmailResponse(messageId.map(value => value))
    def messageId: Optional[OutboundMessageId]
    def getMessageId: ZIO[Any, AwsError, OutboundMessageId] =
      AwsError.unwrapOptionField("messageId", messageId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpointemail.model.SendEmailResponse
  ) extends zio.aws.pinpointemail.model.SendEmailResponse.ReadOnly {
    override val messageId: Optional[OutboundMessageId] = zio.aws.core.internal
      .optionalFromNullable(impl.messageId())
      .map(value =>
        zio.aws.pinpointemail.model.primitives.OutboundMessageId(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpointemail.model.SendEmailResponse
  ): zio.aws.pinpointemail.model.SendEmailResponse.ReadOnly = new Wrapper(impl)
}
