package zio.aws.pinpointemail.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpointemail.model.primitives.{
  CustomRedirectDomain,
  ConfigurationSetName
}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class PutConfigurationSetTrackingOptionsRequest(
    configurationSetName: ConfigurationSetName,
    customRedirectDomain: Optional[CustomRedirectDomain] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpointemail.model.PutConfigurationSetTrackingOptionsRequest = {
    import PutConfigurationSetTrackingOptionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpointemail.model.PutConfigurationSetTrackingOptionsRequest
      .builder()
      .configurationSetName(
        ConfigurationSetName.unwrap(configurationSetName): java.lang.String
      )
      .optionallyWith(
        customRedirectDomain.map(value =>
          CustomRedirectDomain.unwrap(value): java.lang.String
        )
      )(_.customRedirectDomain)
      .build()
  }
  def asReadOnly
      : zio.aws.pinpointemail.model.PutConfigurationSetTrackingOptionsRequest.ReadOnly =
    zio.aws.pinpointemail.model.PutConfigurationSetTrackingOptionsRequest
      .wrap(buildAwsValue())
}
object PutConfigurationSetTrackingOptionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpointemail.model.PutConfigurationSetTrackingOptionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.pinpointemail.model.PutConfigurationSetTrackingOptionsRequest =
      zio.aws.pinpointemail.model.PutConfigurationSetTrackingOptionsRequest(
        configurationSetName,
        customRedirectDomain.map(value => value)
      )
    def configurationSetName: ConfigurationSetName
    def customRedirectDomain: Optional[CustomRedirectDomain]
    def getConfigurationSetName: ZIO[Any, Nothing, ConfigurationSetName] =
      ZIO.succeed(configurationSetName)
    def getCustomRedirectDomain: ZIO[Any, AwsError, CustomRedirectDomain] =
      AwsError.unwrapOptionField("customRedirectDomain", customRedirectDomain)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpointemail.model.PutConfigurationSetTrackingOptionsRequest
  ) extends zio.aws.pinpointemail.model.PutConfigurationSetTrackingOptionsRequest.ReadOnly {
    override val configurationSetName: ConfigurationSetName =
      zio.aws.pinpointemail.model.primitives
        .ConfigurationSetName(impl.configurationSetName())
    override val customRedirectDomain: Optional[CustomRedirectDomain] =
      zio.aws.core.internal
        .optionalFromNullable(impl.customRedirectDomain())
        .map(value =>
          zio.aws.pinpointemail.model.primitives.CustomRedirectDomain(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpointemail.model.PutConfigurationSetTrackingOptionsRequest
  ): zio.aws.pinpointemail.model.PutConfigurationSetTrackingOptionsRequest.ReadOnly =
    new Wrapper(impl)
}
