package zio.aws.pinpointemail.model
import scala.jdk.CollectionConverters._
sealed trait DeliverabilityDashboardAccountStatus {
  def unwrap: software.amazon.awssdk.services.pinpointemail.model.DeliverabilityDashboardAccountStatus
}
object DeliverabilityDashboardAccountStatus {
  def wrap(
      value: software.amazon.awssdk.services.pinpointemail.model.DeliverabilityDashboardAccountStatus
  ): zio.aws.pinpointemail.model.DeliverabilityDashboardAccountStatus =
    value match {
      case software.amazon.awssdk.services.pinpointemail.model.DeliverabilityDashboardAccountStatus.UNKNOWN_TO_SDK_VERSION =>
        val r = unknownToSdkVersion
        r
      case software.amazon.awssdk.services.pinpointemail.model.DeliverabilityDashboardAccountStatus.ACTIVE =>
        val r = ACTIVE
        r
      case software.amazon.awssdk.services.pinpointemail.model.DeliverabilityDashboardAccountStatus.PENDING_EXPIRATION =>
        val r = PENDING_EXPIRATION
        r
      case software.amazon.awssdk.services.pinpointemail.model.DeliverabilityDashboardAccountStatus.DISABLED =>
        val r = DISABLED
        r
    }
  case object unknownToSdkVersion
      extends zio.aws.pinpointemail.model.DeliverabilityDashboardAccountStatus {
    override def unwrap
        : software.amazon.awssdk.services.pinpointemail.model.DeliverabilityDashboardAccountStatus =
      software.amazon.awssdk.services.pinpointemail.model.DeliverabilityDashboardAccountStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object ACTIVE
      extends zio.aws.pinpointemail.model.DeliverabilityDashboardAccountStatus {
    override def unwrap
        : software.amazon.awssdk.services.pinpointemail.model.DeliverabilityDashboardAccountStatus =
      software.amazon.awssdk.services.pinpointemail.model.DeliverabilityDashboardAccountStatus.ACTIVE
  }
  case object PENDING_EXPIRATION
      extends zio.aws.pinpointemail.model.DeliverabilityDashboardAccountStatus {
    override def unwrap
        : software.amazon.awssdk.services.pinpointemail.model.DeliverabilityDashboardAccountStatus =
      software.amazon.awssdk.services.pinpointemail.model.DeliverabilityDashboardAccountStatus.PENDING_EXPIRATION
  }
  case object DISABLED
      extends zio.aws.pinpointemail.model.DeliverabilityDashboardAccountStatus {
    override def unwrap
        : software.amazon.awssdk.services.pinpointemail.model.DeliverabilityDashboardAccountStatus =
      software.amazon.awssdk.services.pinpointemail.model.DeliverabilityDashboardAccountStatus.DISABLED
  }
}
