package zio.aws.pinpointemail.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpointemail.model.primitives.{Charset, MessageData}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Content(
    data: MessageData,
    charset: Optional[Charset] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpointemail.model.Content = {
    import Content.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpointemail.model.Content
      .builder()
      .data(MessageData.unwrap(data): java.lang.String)
      .optionallyWith(
        charset.map(value => Charset.unwrap(value): java.lang.String)
      )(_.charset)
      .build()
  }
  def asReadOnly: zio.aws.pinpointemail.model.Content.ReadOnly =
    zio.aws.pinpointemail.model.Content.wrap(buildAwsValue())
}
object Content {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpointemail.model.Content
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpointemail.model.Content =
      zio.aws.pinpointemail.model.Content(data, charset.map(value => value))
    def data: MessageData
    def charset: Optional[Charset]
    def getData: ZIO[Any, Nothing, MessageData] = ZIO.succeed(data)
    def getCharset: ZIO[Any, AwsError, Charset] =
      AwsError.unwrapOptionField("charset", charset)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpointemail.model.Content
  ) extends zio.aws.pinpointemail.model.Content.ReadOnly {
    override val data: MessageData =
      zio.aws.pinpointemail.model.primitives.MessageData(impl.data())
    override val charset: Optional[Charset] = zio.aws.core.internal
      .optionalFromNullable(impl.charset())
      .map(value => zio.aws.pinpointemail.model.primitives.Charset(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpointemail.model.Content
  ): zio.aws.pinpointemail.model.Content.ReadOnly = new Wrapper(impl)
}
