package zio.aws.pinpointemail.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.pinpointemail.model.primitives.Identity
import scala.jdk.CollectionConverters._
final case class DeleteEmailIdentityRequest(emailIdentity: Identity) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpointemail.model.DeleteEmailIdentityRequest = {
    import DeleteEmailIdentityRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpointemail.model.DeleteEmailIdentityRequest
      .builder()
      .emailIdentity(Identity.unwrap(emailIdentity): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.pinpointemail.model.DeleteEmailIdentityRequest.ReadOnly =
    zio.aws.pinpointemail.model.DeleteEmailIdentityRequest.wrap(buildAwsValue())
}
object DeleteEmailIdentityRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpointemail.model.DeleteEmailIdentityRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpointemail.model.DeleteEmailIdentityRequest =
      zio.aws.pinpointemail.model.DeleteEmailIdentityRequest(emailIdentity)
    def emailIdentity: Identity
    def getEmailIdentity: ZIO[Any, Nothing, Identity] =
      ZIO.succeed(emailIdentity)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpointemail.model.DeleteEmailIdentityRequest
  ) extends zio.aws.pinpointemail.model.DeleteEmailIdentityRequest.ReadOnly {
    override val emailIdentity: Identity =
      zio.aws.pinpointemail.model.primitives.Identity(impl.emailIdentity())
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpointemail.model.DeleteEmailIdentityRequest
  ): zio.aws.pinpointemail.model.DeleteEmailIdentityRequest.ReadOnly =
    new Wrapper(impl)
}
