package zio.aws.pinpointemail.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpointemail.model.primitives.Enabled
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class PutDeliverabilityDashboardOptionRequest(
    dashboardEnabled: Enabled,
    subscribedDomains: Optional[
      Iterable[zio.aws.pinpointemail.model.DomainDeliverabilityTrackingOption]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpointemail.model.PutDeliverabilityDashboardOptionRequest = {
    import PutDeliverabilityDashboardOptionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpointemail.model.PutDeliverabilityDashboardOptionRequest
      .builder()
      .dashboardEnabled(Enabled.unwrap(dashboardEnabled): java.lang.Boolean)
      .optionallyWith(
        subscribedDomains.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.subscribedDomains)
      .build()
  }
  def asReadOnly
      : zio.aws.pinpointemail.model.PutDeliverabilityDashboardOptionRequest.ReadOnly =
    zio.aws.pinpointemail.model.PutDeliverabilityDashboardOptionRequest
      .wrap(buildAwsValue())
}
object PutDeliverabilityDashboardOptionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpointemail.model.PutDeliverabilityDashboardOptionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.pinpointemail.model.PutDeliverabilityDashboardOptionRequest =
      zio.aws.pinpointemail.model.PutDeliverabilityDashboardOptionRequest(
        dashboardEnabled,
        subscribedDomains.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def dashboardEnabled: Enabled
    def subscribedDomains: Optional[List[
      zio.aws.pinpointemail.model.DomainDeliverabilityTrackingOption.ReadOnly
    ]]
    def getDashboardEnabled: ZIO[Any, Nothing, Enabled] =
      ZIO.succeed(dashboardEnabled)
    def getSubscribedDomains: ZIO[Any, AwsError, List[
      zio.aws.pinpointemail.model.DomainDeliverabilityTrackingOption.ReadOnly
    ]] = AwsError.unwrapOptionField("subscribedDomains", subscribedDomains)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpointemail.model.PutDeliverabilityDashboardOptionRequest
  ) extends zio.aws.pinpointemail.model.PutDeliverabilityDashboardOptionRequest.ReadOnly {
    override val dashboardEnabled: Enabled =
      zio.aws.pinpointemail.model.primitives.Enabled(impl.dashboardEnabled())
    override val subscribedDomains: Optional[List[
      zio.aws.pinpointemail.model.DomainDeliverabilityTrackingOption.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.subscribedDomains())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.pinpointemail.model.DomainDeliverabilityTrackingOption
            .wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpointemail.model.PutDeliverabilityDashboardOptionRequest
  ): zio.aws.pinpointemail.model.PutDeliverabilityDashboardOptionRequest.ReadOnly =
    new Wrapper(impl)
}
