package zio.aws.pinpointemail.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetConfigurationSetEventDestinationsResponse(
    eventDestinations: Optional[
      Iterable[zio.aws.pinpointemail.model.EventDestination]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpointemail.model.GetConfigurationSetEventDestinationsResponse = {
    import GetConfigurationSetEventDestinationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpointemail.model.GetConfigurationSetEventDestinationsResponse
      .builder()
      .optionallyWith(
        eventDestinations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.eventDestinations)
      .build()
  }
  def asReadOnly
      : zio.aws.pinpointemail.model.GetConfigurationSetEventDestinationsResponse.ReadOnly =
    zio.aws.pinpointemail.model.GetConfigurationSetEventDestinationsResponse
      .wrap(buildAwsValue())
}
object GetConfigurationSetEventDestinationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpointemail.model.GetConfigurationSetEventDestinationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.pinpointemail.model.GetConfigurationSetEventDestinationsResponse =
      zio.aws.pinpointemail.model.GetConfigurationSetEventDestinationsResponse(
        eventDestinations.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def eventDestinations
        : Optional[List[zio.aws.pinpointemail.model.EventDestination.ReadOnly]]
    def getEventDestinations: ZIO[Any, AwsError, List[
      zio.aws.pinpointemail.model.EventDestination.ReadOnly
    ]] = AwsError.unwrapOptionField("eventDestinations", eventDestinations)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpointemail.model.GetConfigurationSetEventDestinationsResponse
  ) extends zio.aws.pinpointemail.model.GetConfigurationSetEventDestinationsResponse.ReadOnly {
    override val eventDestinations: Optional[
      List[zio.aws.pinpointemail.model.EventDestination.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.eventDestinations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.pinpointemail.model.EventDestination.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpointemail.model.GetConfigurationSetEventDestinationsResponse
  ): zio.aws.pinpointemail.model.GetConfigurationSetEventDestinationsResponse.ReadOnly =
    new Wrapper(impl)
}
