package zio.aws.pinpointemail.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.pinpointemail.model.primitives.ConfigurationSetName
import scala.jdk.CollectionConverters._
final case class DeleteConfigurationSetRequest(
    configurationSetName: ConfigurationSetName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpointemail.model.DeleteConfigurationSetRequest = {
    import DeleteConfigurationSetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpointemail.model.DeleteConfigurationSetRequest
      .builder()
      .configurationSetName(
        ConfigurationSetName.unwrap(configurationSetName): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.pinpointemail.model.DeleteConfigurationSetRequest.ReadOnly =
    zio.aws.pinpointemail.model.DeleteConfigurationSetRequest
      .wrap(buildAwsValue())
}
object DeleteConfigurationSetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpointemail.model.DeleteConfigurationSetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpointemail.model.DeleteConfigurationSetRequest =
      zio.aws.pinpointemail.model
        .DeleteConfigurationSetRequest(configurationSetName)
    def configurationSetName: ConfigurationSetName
    def getConfigurationSetName: ZIO[Any, Nothing, ConfigurationSetName] =
      ZIO.succeed(configurationSetName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpointemail.model.DeleteConfigurationSetRequest
  ) extends zio.aws.pinpointemail.model.DeleteConfigurationSetRequest.ReadOnly {
    override val configurationSetName: ConfigurationSetName =
      zio.aws.pinpointemail.model.primitives
        .ConfigurationSetName(impl.configurationSetName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpointemail.model.DeleteConfigurationSetRequest
  ): zio.aws.pinpointemail.model.DeleteConfigurationSetRequest.ReadOnly =
    new Wrapper(impl)
}
