package zio.aws.pinpointemail
import zio.aws.pinpointemail.model.CreateConfigurationSetEventDestinationResponse.ReadOnly
import zio.mock.{Proxy, Mock}
import zio.aws.pinpointemail.model.primitives.{ConfigurationSetName, PoolName}
import zio.aws.core.AwsError
import software.amazon.awssdk.services.pinpointemail.PinpointEmailAsyncClient
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import zio.aws.pinpointemail.model.{
  DeleteDedicatedIpPoolRequest,
  DeleteConfigurationSetRequest,
  PutDeliverabilityDashboardOptionRequest,
  GetDedicatedIpRequest,
  UpdateConfigurationSetEventDestinationRequest,
  CreateDeliverabilityTestReportRequest,
  GetDomainDeliverabilityCampaignRequest,
  PutConfigurationSetSendingOptionsRequest,
  GetEmailIdentityRequest,
  PutAccountSendingAttributesRequest,
  PutEmailIdentityFeedbackAttributesRequest,
  PutDedicatedIpWarmupAttributesRequest,
  ListTagsForResourceRequest,
  CreateConfigurationSetRequest,
  CreateEmailIdentityRequest,
  PutAccountDedicatedIpWarmupAttributesRequest,
  GetConfigurationSetRequest,
  GetBlacklistReportsRequest,
  GetDedicatedIpsRequest,
  ListDedicatedIpPoolsRequest,
  ListEmailIdentitiesRequest,
  PutEmailIdentityDkimAttributesRequest,
  SendEmailRequest,
  PutConfigurationSetTrackingOptionsRequest,
  GetAccountRequest,
  PutConfigurationSetDeliveryOptionsRequest,
  ListConfigurationSetsRequest,
  GetConfigurationSetEventDestinationsRequest,
  ListDeliverabilityTestReportsRequest,
  GetDomainStatisticsReportRequest,
  CreateConfigurationSetEventDestinationRequest,
  UntagResourceRequest,
  PutDedicatedIpInPoolRequest,
  GetDeliverabilityDashboardOptionsRequest,
  PutConfigurationSetReputationOptionsRequest,
  DeleteConfigurationSetEventDestinationRequest,
  ListDomainDeliverabilityCampaignsRequest,
  CreateDedicatedIpPoolRequest,
  GetDeliverabilityTestReportRequest,
  PutEmailIdentityMailFromAttributesRequest,
  TagResourceRequest,
  DeleteEmailIdentityRequest
}
import zio.stream.ZStream
object PinpointEmailMock extends Mock[PinpointEmail] {
  object GetConfigurationSet
      extends Effect[
        GetConfigurationSetRequest,
        AwsError,
        zio.aws.pinpointemail.model.GetConfigurationSetResponse.ReadOnly
      ]
  object GetDomainDeliverabilityCampaign
      extends Effect[
        GetDomainDeliverabilityCampaignRequest,
        AwsError,
        zio.aws.pinpointemail.model.GetDomainDeliverabilityCampaignResponse.ReadOnly
      ]
  object CreateConfigurationSetEventDestination
      extends Effect[
        CreateConfigurationSetEventDestinationRequest,
        AwsError,
        ReadOnly
      ]
  object PutConfigurationSetReputationOptions
      extends Effect[
        PutConfigurationSetReputationOptionsRequest,
        AwsError,
        zio.aws.pinpointemail.model.PutConfigurationSetReputationOptionsResponse.ReadOnly
      ]
  object PutAccountSendingAttributes
      extends Effect[
        PutAccountSendingAttributesRequest,
        AwsError,
        zio.aws.pinpointemail.model.PutAccountSendingAttributesResponse.ReadOnly
      ]
  object ListEmailIdentities
      extends Stream[
        ListEmailIdentitiesRequest,
        AwsError,
        zio.aws.pinpointemail.model.IdentityInfo.ReadOnly
      ]
  object ListEmailIdentitiesPaginated
      extends Effect[
        ListEmailIdentitiesRequest,
        AwsError,
        zio.aws.pinpointemail.model.ListEmailIdentitiesResponse.ReadOnly
      ]
  object CreateEmailIdentity
      extends Effect[
        CreateEmailIdentityRequest,
        AwsError,
        zio.aws.pinpointemail.model.CreateEmailIdentityResponse.ReadOnly
      ]
  object ListDedicatedIpPools
      extends Stream[ListDedicatedIpPoolsRequest, AwsError, PoolName]
  object ListDedicatedIpPoolsPaginated
      extends Effect[
        ListDedicatedIpPoolsRequest,
        AwsError,
        zio.aws.pinpointemail.model.ListDedicatedIpPoolsResponse.ReadOnly
      ]
  object PutAccountDedicatedIpWarmupAttributes
      extends Effect[
        PutAccountDedicatedIpWarmupAttributesRequest,
        AwsError,
        zio.aws.pinpointemail.model.PutAccountDedicatedIpWarmupAttributesResponse.ReadOnly
      ]
  object GetConfigurationSetEventDestinations
      extends Effect[
        GetConfigurationSetEventDestinationsRequest,
        AwsError,
        zio.aws.pinpointemail.model.GetConfigurationSetEventDestinationsResponse.ReadOnly
      ]
  object SendEmail
      extends Effect[
        SendEmailRequest,
        AwsError,
        zio.aws.pinpointemail.model.SendEmailResponse.ReadOnly
      ]
  object GetEmailIdentity
      extends Effect[
        GetEmailIdentityRequest,
        AwsError,
        zio.aws.pinpointemail.model.GetEmailIdentityResponse.ReadOnly
      ]
  object PutConfigurationSetTrackingOptions
      extends Effect[
        PutConfigurationSetTrackingOptionsRequest,
        AwsError,
        zio.aws.pinpointemail.model.PutConfigurationSetTrackingOptionsResponse.ReadOnly
      ]
  object DeleteEmailIdentity
      extends Effect[
        DeleteEmailIdentityRequest,
        AwsError,
        zio.aws.pinpointemail.model.DeleteEmailIdentityResponse.ReadOnly
      ]
  object GetDeliverabilityDashboardOptions
      extends Effect[
        GetDeliverabilityDashboardOptionsRequest,
        AwsError,
        zio.aws.pinpointemail.model.GetDeliverabilityDashboardOptionsResponse.ReadOnly
      ]
  object GetAccount
      extends Effect[
        GetAccountRequest,
        AwsError,
        zio.aws.pinpointemail.model.GetAccountResponse.ReadOnly
      ]
  object GetDomainStatisticsReport
      extends Effect[
        GetDomainStatisticsReportRequest,
        AwsError,
        zio.aws.pinpointemail.model.GetDomainStatisticsReportResponse.ReadOnly
      ]
  object GetDedicatedIps
      extends Stream[
        GetDedicatedIpsRequest,
        AwsError,
        zio.aws.pinpointemail.model.DedicatedIp.ReadOnly
      ]
  object GetDedicatedIpsPaginated
      extends Effect[
        GetDedicatedIpsRequest,
        AwsError,
        zio.aws.pinpointemail.model.GetDedicatedIpsResponse.ReadOnly
      ]
  object CreateDeliverabilityTestReport
      extends Effect[
        CreateDeliverabilityTestReportRequest,
        AwsError,
        zio.aws.pinpointemail.model.CreateDeliverabilityTestReportResponse.ReadOnly
      ]
  object ListDomainDeliverabilityCampaigns
      extends Stream[
        ListDomainDeliverabilityCampaignsRequest,
        AwsError,
        zio.aws.pinpointemail.model.DomainDeliverabilityCampaign.ReadOnly
      ]
  object ListDomainDeliverabilityCampaignsPaginated
      extends Effect[
        ListDomainDeliverabilityCampaignsRequest,
        AwsError,
        zio.aws.pinpointemail.model.ListDomainDeliverabilityCampaignsResponse.ReadOnly
      ]
  object GetBlacklistReports
      extends Effect[
        GetBlacklistReportsRequest,
        AwsError,
        zio.aws.pinpointemail.model.GetBlacklistReportsResponse.ReadOnly
      ]
  object UntagResource
      extends Effect[
        UntagResourceRequest,
        AwsError,
        zio.aws.pinpointemail.model.UntagResourceResponse.ReadOnly
      ]
  object CreateDedicatedIpPool
      extends Effect[
        CreateDedicatedIpPoolRequest,
        AwsError,
        zio.aws.pinpointemail.model.CreateDedicatedIpPoolResponse.ReadOnly
      ]
  object ListConfigurationSets
      extends Stream[
        ListConfigurationSetsRequest,
        AwsError,
        ConfigurationSetName
      ]
  object ListConfigurationSetsPaginated
      extends Effect[
        ListConfigurationSetsRequest,
        AwsError,
        zio.aws.pinpointemail.model.ListConfigurationSetsResponse.ReadOnly
      ]
  object PutEmailIdentityMailFromAttributes
      extends Effect[
        PutEmailIdentityMailFromAttributesRequest,
        AwsError,
        zio.aws.pinpointemail.model.PutEmailIdentityMailFromAttributesResponse.ReadOnly
      ]
  object PutEmailIdentityFeedbackAttributes
      extends Effect[
        PutEmailIdentityFeedbackAttributesRequest,
        AwsError,
        zio.aws.pinpointemail.model.PutEmailIdentityFeedbackAttributesResponse.ReadOnly
      ]
  object ListTagsForResource
      extends Effect[
        ListTagsForResourceRequest,
        AwsError,
        zio.aws.pinpointemail.model.ListTagsForResourceResponse.ReadOnly
      ]
  object DeleteDedicatedIpPool
      extends Effect[
        DeleteDedicatedIpPoolRequest,
        AwsError,
        zio.aws.pinpointemail.model.DeleteDedicatedIpPoolResponse.ReadOnly
      ]
  object GetDedicatedIp
      extends Effect[
        GetDedicatedIpRequest,
        AwsError,
        zio.aws.pinpointemail.model.GetDedicatedIpResponse.ReadOnly
      ]
  object PutDeliverabilityDashboardOption
      extends Effect[
        PutDeliverabilityDashboardOptionRequest,
        AwsError,
        zio.aws.pinpointemail.model.PutDeliverabilityDashboardOptionResponse.ReadOnly
      ]
  object TagResource
      extends Effect[
        TagResourceRequest,
        AwsError,
        zio.aws.pinpointemail.model.TagResourceResponse.ReadOnly
      ]
  object DeleteConfigurationSet
      extends Effect[
        DeleteConfigurationSetRequest,
        AwsError,
        zio.aws.pinpointemail.model.DeleteConfigurationSetResponse.ReadOnly
      ]
  object CreateConfigurationSet
      extends Effect[
        CreateConfigurationSetRequest,
        AwsError,
        zio.aws.pinpointemail.model.CreateConfigurationSetResponse.ReadOnly
      ]
  object ListDeliverabilityTestReports
      extends Stream[
        ListDeliverabilityTestReportsRequest,
        AwsError,
        zio.aws.pinpointemail.model.DeliverabilityTestReport.ReadOnly
      ]
  object ListDeliverabilityTestReportsPaginated
      extends Effect[
        ListDeliverabilityTestReportsRequest,
        AwsError,
        zio.aws.pinpointemail.model.ListDeliverabilityTestReportsResponse.ReadOnly
      ]
  object UpdateConfigurationSetEventDestination
      extends Effect[
        UpdateConfigurationSetEventDestinationRequest,
        AwsError,
        zio.aws.pinpointemail.model.UpdateConfigurationSetEventDestinationResponse.ReadOnly
      ]
  object PutDedicatedIpInPool
      extends Effect[
        PutDedicatedIpInPoolRequest,
        AwsError,
        zio.aws.pinpointemail.model.PutDedicatedIpInPoolResponse.ReadOnly
      ]
  object PutConfigurationSetSendingOptions
      extends Effect[
        PutConfigurationSetSendingOptionsRequest,
        AwsError,
        zio.aws.pinpointemail.model.PutConfigurationSetSendingOptionsResponse.ReadOnly
      ]
  object PutConfigurationSetDeliveryOptions
      extends Effect[
        PutConfigurationSetDeliveryOptionsRequest,
        AwsError,
        zio.aws.pinpointemail.model.PutConfigurationSetDeliveryOptionsResponse.ReadOnly
      ]
  object GetDeliverabilityTestReport
      extends Effect[
        GetDeliverabilityTestReportRequest,
        AwsError,
        zio.aws.pinpointemail.model.GetDeliverabilityTestReportResponse.ReadOnly
      ]
  object PutDedicatedIpWarmupAttributes
      extends Effect[
        PutDedicatedIpWarmupAttributesRequest,
        AwsError,
        zio.aws.pinpointemail.model.PutDedicatedIpWarmupAttributesResponse.ReadOnly
      ]
  object DeleteConfigurationSetEventDestination
      extends Effect[
        DeleteConfigurationSetEventDestinationRequest,
        AwsError,
        zio.aws.pinpointemail.model.DeleteConfigurationSetEventDestinationResponse.ReadOnly
      ]
  object PutEmailIdentityDkimAttributes
      extends Effect[
        PutEmailIdentityDkimAttributesRequest,
        AwsError,
        zio.aws.pinpointemail.model.PutEmailIdentityDkimAttributesResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, PinpointEmail] = zio.ZLayer {
    zio.ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy, PinpointEmail] { rts =>
        zio.ZIO.succeed {
          new PinpointEmail {
            val api: PinpointEmailAsyncClient = null
            def withAspect[R1](
                newAspect: AwsCallAspect[R1],
                r: ZEnvironment[R1]
            ): PinpointEmail = this
            def getConfigurationSet(request: GetConfigurationSetRequest): IO[
              AwsError,
              zio.aws.pinpointemail.model.GetConfigurationSetResponse.ReadOnly
            ] = proxy(GetConfigurationSet, request)
            def getDomainDeliverabilityCampaign(
                request: GetDomainDeliverabilityCampaignRequest
            ): IO[
              AwsError,
              zio.aws.pinpointemail.model.GetDomainDeliverabilityCampaignResponse.ReadOnly
            ] = proxy(GetDomainDeliverabilityCampaign, request)
            def createConfigurationSetEventDestination(
                request: CreateConfigurationSetEventDestinationRequest
            ): IO[AwsError, ReadOnly] =
              proxy(CreateConfigurationSetEventDestination, request)
            def putConfigurationSetReputationOptions(
                request: PutConfigurationSetReputationOptionsRequest
            ): IO[
              AwsError,
              zio.aws.pinpointemail.model.PutConfigurationSetReputationOptionsResponse.ReadOnly
            ] = proxy(PutConfigurationSetReputationOptions, request)
            def putAccountSendingAttributes(
                request: PutAccountSendingAttributesRequest
            ): IO[
              AwsError,
              zio.aws.pinpointemail.model.PutAccountSendingAttributesResponse.ReadOnly
            ] = proxy(PutAccountSendingAttributes, request)
            def listEmailIdentities(
                request: ListEmailIdentitiesRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.pinpointemail.model.IdentityInfo.ReadOnly
            ] = zio.Unsafe.unsafeCompat { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListEmailIdentities, request)
                }
                .getOrThrowFiberFailure()
            }
            def listEmailIdentitiesPaginated(
                request: ListEmailIdentitiesRequest
            ): IO[
              AwsError,
              zio.aws.pinpointemail.model.ListEmailIdentitiesResponse.ReadOnly
            ] = proxy(ListEmailIdentitiesPaginated, request)
            def createEmailIdentity(request: CreateEmailIdentityRequest): IO[
              AwsError,
              zio.aws.pinpointemail.model.CreateEmailIdentityResponse.ReadOnly
            ] = proxy(CreateEmailIdentity, request)
            def listDedicatedIpPools(
                request: ListDedicatedIpPoolsRequest
            ): ZStream[Any, AwsError, PoolName] =
              zio.Unsafe.unsafeCompat { implicit u =>
                rts.unsafe
                  .run {
                    proxy(ListDedicatedIpPools, request)
                  }
                  .getOrThrowFiberFailure()
              }
            def listDedicatedIpPoolsPaginated(
                request: ListDedicatedIpPoolsRequest
            ): IO[
              AwsError,
              zio.aws.pinpointemail.model.ListDedicatedIpPoolsResponse.ReadOnly
            ] = proxy(ListDedicatedIpPoolsPaginated, request)
            def putAccountDedicatedIpWarmupAttributes(
                request: PutAccountDedicatedIpWarmupAttributesRequest
            ): IO[
              AwsError,
              zio.aws.pinpointemail.model.PutAccountDedicatedIpWarmupAttributesResponse.ReadOnly
            ] = proxy(PutAccountDedicatedIpWarmupAttributes, request)
            def getConfigurationSetEventDestinations(
                request: GetConfigurationSetEventDestinationsRequest
            ): IO[
              AwsError,
              zio.aws.pinpointemail.model.GetConfigurationSetEventDestinationsResponse.ReadOnly
            ] = proxy(GetConfigurationSetEventDestinations, request)
            def sendEmail(request: SendEmailRequest): IO[
              AwsError,
              zio.aws.pinpointemail.model.SendEmailResponse.ReadOnly
            ] = proxy(SendEmail, request)
            def getEmailIdentity(request: GetEmailIdentityRequest): IO[
              AwsError,
              zio.aws.pinpointemail.model.GetEmailIdentityResponse.ReadOnly
            ] = proxy(GetEmailIdentity, request)
            def putConfigurationSetTrackingOptions(
                request: PutConfigurationSetTrackingOptionsRequest
            ): IO[
              AwsError,
              zio.aws.pinpointemail.model.PutConfigurationSetTrackingOptionsResponse.ReadOnly
            ] = proxy(PutConfigurationSetTrackingOptions, request)
            def deleteEmailIdentity(request: DeleteEmailIdentityRequest): IO[
              AwsError,
              zio.aws.pinpointemail.model.DeleteEmailIdentityResponse.ReadOnly
            ] = proxy(DeleteEmailIdentity, request)
            def getDeliverabilityDashboardOptions(
                request: GetDeliverabilityDashboardOptionsRequest
            ): IO[
              AwsError,
              zio.aws.pinpointemail.model.GetDeliverabilityDashboardOptionsResponse.ReadOnly
            ] = proxy(GetDeliverabilityDashboardOptions, request)
            def getAccount(request: GetAccountRequest): IO[
              AwsError,
              zio.aws.pinpointemail.model.GetAccountResponse.ReadOnly
            ] = proxy(GetAccount, request)
            def getDomainStatisticsReport(
                request: GetDomainStatisticsReportRequest
            ): IO[
              AwsError,
              zio.aws.pinpointemail.model.GetDomainStatisticsReportResponse.ReadOnly
            ] = proxy(GetDomainStatisticsReport, request)
            def getDedicatedIps(request: GetDedicatedIpsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.pinpointemail.model.DedicatedIp.ReadOnly
            ] = zio.Unsafe.unsafeCompat { implicit u =>
              rts.unsafe
                .run {
                  proxy(GetDedicatedIps, request)
                }
                .getOrThrowFiberFailure()
            }
            def getDedicatedIpsPaginated(request: GetDedicatedIpsRequest): IO[
              AwsError,
              zio.aws.pinpointemail.model.GetDedicatedIpsResponse.ReadOnly
            ] = proxy(GetDedicatedIpsPaginated, request)
            def createDeliverabilityTestReport(
                request: CreateDeliverabilityTestReportRequest
            ): IO[
              AwsError,
              zio.aws.pinpointemail.model.CreateDeliverabilityTestReportResponse.ReadOnly
            ] = proxy(CreateDeliverabilityTestReport, request)
            def listDomainDeliverabilityCampaigns(
                request: ListDomainDeliverabilityCampaignsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.pinpointemail.model.DomainDeliverabilityCampaign.ReadOnly
            ] = zio.Unsafe.unsafeCompat { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListDomainDeliverabilityCampaigns, request)
                }
                .getOrThrowFiberFailure()
            }
            def listDomainDeliverabilityCampaignsPaginated(
                request: ListDomainDeliverabilityCampaignsRequest
            ): IO[
              AwsError,
              zio.aws.pinpointemail.model.ListDomainDeliverabilityCampaignsResponse.ReadOnly
            ] = proxy(ListDomainDeliverabilityCampaignsPaginated, request)
            def getBlacklistReports(request: GetBlacklistReportsRequest): IO[
              AwsError,
              zio.aws.pinpointemail.model.GetBlacklistReportsResponse.ReadOnly
            ] = proxy(GetBlacklistReports, request)
            def untagResource(request: UntagResourceRequest): IO[
              AwsError,
              zio.aws.pinpointemail.model.UntagResourceResponse.ReadOnly
            ] = proxy(UntagResource, request)
            def createDedicatedIpPool(
                request: CreateDedicatedIpPoolRequest
            ): IO[
              AwsError,
              zio.aws.pinpointemail.model.CreateDedicatedIpPoolResponse.ReadOnly
            ] = proxy(CreateDedicatedIpPool, request)
            def listConfigurationSets(
                request: ListConfigurationSetsRequest
            ): ZStream[Any, AwsError, ConfigurationSetName] =
              zio.Unsafe.unsafeCompat { implicit u =>
                rts.unsafe
                  .run {
                    proxy(ListConfigurationSets, request)
                  }
                  .getOrThrowFiberFailure()
              }
            def listConfigurationSetsPaginated(
                request: ListConfigurationSetsRequest
            ): IO[
              AwsError,
              zio.aws.pinpointemail.model.ListConfigurationSetsResponse.ReadOnly
            ] = proxy(ListConfigurationSetsPaginated, request)
            def putEmailIdentityMailFromAttributes(
                request: PutEmailIdentityMailFromAttributesRequest
            ): IO[
              AwsError,
              zio.aws.pinpointemail.model.PutEmailIdentityMailFromAttributesResponse.ReadOnly
            ] = proxy(PutEmailIdentityMailFromAttributes, request)
            def putEmailIdentityFeedbackAttributes(
                request: PutEmailIdentityFeedbackAttributesRequest
            ): IO[
              AwsError,
              zio.aws.pinpointemail.model.PutEmailIdentityFeedbackAttributesResponse.ReadOnly
            ] = proxy(PutEmailIdentityFeedbackAttributes, request)
            def listTagsForResource(request: ListTagsForResourceRequest): IO[
              AwsError,
              zio.aws.pinpointemail.model.ListTagsForResourceResponse.ReadOnly
            ] = proxy(ListTagsForResource, request)
            def deleteDedicatedIpPool(
                request: DeleteDedicatedIpPoolRequest
            ): IO[
              AwsError,
              zio.aws.pinpointemail.model.DeleteDedicatedIpPoolResponse.ReadOnly
            ] = proxy(DeleteDedicatedIpPool, request)
            def getDedicatedIp(request: GetDedicatedIpRequest): IO[
              AwsError,
              zio.aws.pinpointemail.model.GetDedicatedIpResponse.ReadOnly
            ] = proxy(GetDedicatedIp, request)
            def putDeliverabilityDashboardOption(
                request: PutDeliverabilityDashboardOptionRequest
            ): IO[
              AwsError,
              zio.aws.pinpointemail.model.PutDeliverabilityDashboardOptionResponse.ReadOnly
            ] = proxy(PutDeliverabilityDashboardOption, request)
            def tagResource(request: TagResourceRequest): IO[
              AwsError,
              zio.aws.pinpointemail.model.TagResourceResponse.ReadOnly
            ] = proxy(TagResource, request)
            def deleteConfigurationSet(
                request: DeleteConfigurationSetRequest
            ): IO[
              AwsError,
              zio.aws.pinpointemail.model.DeleteConfigurationSetResponse.ReadOnly
            ] = proxy(DeleteConfigurationSet, request)
            def createConfigurationSet(
                request: CreateConfigurationSetRequest
            ): IO[
              AwsError,
              zio.aws.pinpointemail.model.CreateConfigurationSetResponse.ReadOnly
            ] = proxy(CreateConfigurationSet, request)
            def listDeliverabilityTestReports(
                request: ListDeliverabilityTestReportsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.pinpointemail.model.DeliverabilityTestReport.ReadOnly
            ] = zio.Unsafe.unsafeCompat { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListDeliverabilityTestReports, request)
                }
                .getOrThrowFiberFailure()
            }
            def listDeliverabilityTestReportsPaginated(
                request: ListDeliverabilityTestReportsRequest
            ): IO[
              AwsError,
              zio.aws.pinpointemail.model.ListDeliverabilityTestReportsResponse.ReadOnly
            ] = proxy(ListDeliverabilityTestReportsPaginated, request)
            def updateConfigurationSetEventDestination(
                request: UpdateConfigurationSetEventDestinationRequest
            ): IO[
              AwsError,
              zio.aws.pinpointemail.model.UpdateConfigurationSetEventDestinationResponse.ReadOnly
            ] = proxy(UpdateConfigurationSetEventDestination, request)
            def putDedicatedIpInPool(request: PutDedicatedIpInPoolRequest): IO[
              AwsError,
              zio.aws.pinpointemail.model.PutDedicatedIpInPoolResponse.ReadOnly
            ] = proxy(PutDedicatedIpInPool, request)
            def putConfigurationSetSendingOptions(
                request: PutConfigurationSetSendingOptionsRequest
            ): IO[
              AwsError,
              zio.aws.pinpointemail.model.PutConfigurationSetSendingOptionsResponse.ReadOnly
            ] = proxy(PutConfigurationSetSendingOptions, request)
            def putConfigurationSetDeliveryOptions(
                request: PutConfigurationSetDeliveryOptionsRequest
            ): IO[
              AwsError,
              zio.aws.pinpointemail.model.PutConfigurationSetDeliveryOptionsResponse.ReadOnly
            ] = proxy(PutConfigurationSetDeliveryOptions, request)
            def getDeliverabilityTestReport(
                request: GetDeliverabilityTestReportRequest
            ): IO[
              AwsError,
              zio.aws.pinpointemail.model.GetDeliverabilityTestReportResponse.ReadOnly
            ] = proxy(GetDeliverabilityTestReport, request)
            def putDedicatedIpWarmupAttributes(
                request: PutDedicatedIpWarmupAttributesRequest
            ): IO[
              AwsError,
              zio.aws.pinpointemail.model.PutDedicatedIpWarmupAttributesResponse.ReadOnly
            ] = proxy(PutDedicatedIpWarmupAttributes, request)
            def deleteConfigurationSetEventDestination(
                request: DeleteConfigurationSetEventDestinationRequest
            ): IO[
              AwsError,
              zio.aws.pinpointemail.model.DeleteConfigurationSetEventDestinationResponse.ReadOnly
            ] = proxy(DeleteConfigurationSetEventDestination, request)
            def putEmailIdentityDkimAttributes(
                request: PutEmailIdentityDkimAttributesRequest
            ): IO[
              AwsError,
              zio.aws.pinpointemail.model.PutEmailIdentityDkimAttributesResponse.ReadOnly
            ] = proxy(PutEmailIdentityDkimAttributes, request)
          }
        }
      }
    }
  }
}
