package zio.aws.pinpointemail.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpointemail.model.primitives.ConfigurationSetName
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetConfigurationSetResponse(
    configurationSetName: Optional[ConfigurationSetName] = Optional.Absent,
    trackingOptions: Optional[zio.aws.pinpointemail.model.TrackingOptions] =
      Optional.Absent,
    deliveryOptions: Optional[zio.aws.pinpointemail.model.DeliveryOptions] =
      Optional.Absent,
    reputationOptions: Optional[zio.aws.pinpointemail.model.ReputationOptions] =
      Optional.Absent,
    sendingOptions: Optional[zio.aws.pinpointemail.model.SendingOptions] =
      Optional.Absent,
    tags: Optional[Iterable[zio.aws.pinpointemail.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpointemail.model.GetConfigurationSetResponse = {
    import GetConfigurationSetResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpointemail.model.GetConfigurationSetResponse
      .builder()
      .optionallyWith(
        configurationSetName.map(value =>
          ConfigurationSetName.unwrap(value): java.lang.String
        )
      )(_.configurationSetName)
      .optionallyWith(trackingOptions.map(value => value.buildAwsValue()))(
        _.trackingOptions
      )
      .optionallyWith(deliveryOptions.map(value => value.buildAwsValue()))(
        _.deliveryOptions
      )
      .optionallyWith(reputationOptions.map(value => value.buildAwsValue()))(
        _.reputationOptions
      )
      .optionallyWith(sendingOptions.map(value => value.buildAwsValue()))(
        _.sendingOptions
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.pinpointemail.model.GetConfigurationSetResponse.ReadOnly =
    zio.aws.pinpointemail.model.GetConfigurationSetResponse
      .wrap(buildAwsValue())
}
object GetConfigurationSetResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpointemail.model.GetConfigurationSetResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpointemail.model.GetConfigurationSetResponse =
      zio.aws.pinpointemail.model.GetConfigurationSetResponse(
        configurationSetName.map(value => value),
        trackingOptions.map(value => value.asEditable),
        deliveryOptions.map(value => value.asEditable),
        reputationOptions.map(value => value.asEditable),
        sendingOptions.map(value => value.asEditable),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def configurationSetName: Optional[ConfigurationSetName]
    def trackingOptions
        : Optional[zio.aws.pinpointemail.model.TrackingOptions.ReadOnly]
    def deliveryOptions
        : Optional[zio.aws.pinpointemail.model.DeliveryOptions.ReadOnly]
    def reputationOptions
        : Optional[zio.aws.pinpointemail.model.ReputationOptions.ReadOnly]
    def sendingOptions
        : Optional[zio.aws.pinpointemail.model.SendingOptions.ReadOnly]
    def tags: Optional[List[zio.aws.pinpointemail.model.Tag.ReadOnly]]
    def getConfigurationSetName: ZIO[Any, AwsError, ConfigurationSetName] =
      AwsError.unwrapOptionField("configurationSetName", configurationSetName)
    def getTrackingOptions: ZIO[
      Any,
      AwsError,
      zio.aws.pinpointemail.model.TrackingOptions.ReadOnly
    ] = AwsError.unwrapOptionField("trackingOptions", trackingOptions)
    def getDeliveryOptions: ZIO[
      Any,
      AwsError,
      zio.aws.pinpointemail.model.DeliveryOptions.ReadOnly
    ] = AwsError.unwrapOptionField("deliveryOptions", deliveryOptions)
    def getReputationOptions: ZIO[
      Any,
      AwsError,
      zio.aws.pinpointemail.model.ReputationOptions.ReadOnly
    ] = AwsError.unwrapOptionField("reputationOptions", reputationOptions)
    def getSendingOptions: ZIO[
      Any,
      AwsError,
      zio.aws.pinpointemail.model.SendingOptions.ReadOnly
    ] = AwsError.unwrapOptionField("sendingOptions", sendingOptions)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.pinpointemail.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpointemail.model.GetConfigurationSetResponse
  ) extends zio.aws.pinpointemail.model.GetConfigurationSetResponse.ReadOnly {
    override val configurationSetName: Optional[ConfigurationSetName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.configurationSetName())
        .map(value =>
          zio.aws.pinpointemail.model.primitives.ConfigurationSetName(value)
        )
    override val trackingOptions
        : Optional[zio.aws.pinpointemail.model.TrackingOptions.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.trackingOptions())
        .map(value => zio.aws.pinpointemail.model.TrackingOptions.wrap(value))
    override val deliveryOptions
        : Optional[zio.aws.pinpointemail.model.DeliveryOptions.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deliveryOptions())
        .map(value => zio.aws.pinpointemail.model.DeliveryOptions.wrap(value))
    override val reputationOptions
        : Optional[zio.aws.pinpointemail.model.ReputationOptions.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.reputationOptions())
        .map(value => zio.aws.pinpointemail.model.ReputationOptions.wrap(value))
    override val sendingOptions
        : Optional[zio.aws.pinpointemail.model.SendingOptions.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sendingOptions())
        .map(value => zio.aws.pinpointemail.model.SendingOptions.wrap(value))
    override val tags
        : Optional[List[zio.aws.pinpointemail.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.pinpointemail.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpointemail.model.GetConfigurationSetResponse
  ): zio.aws.pinpointemail.model.GetConfigurationSetResponse.ReadOnly =
    new Wrapper(impl)
}
