package zio.aws.pinpointemail.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class EmailContent(
    simple: Optional[zio.aws.pinpointemail.model.Message] = Optional.Absent,
    raw: Optional[zio.aws.pinpointemail.model.RawMessage] = Optional.Absent,
    template: Optional[zio.aws.pinpointemail.model.Template] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpointemail.model.EmailContent = {
    import EmailContent.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpointemail.model.EmailContent
      .builder()
      .optionallyWith(simple.map(value => value.buildAwsValue()))(_.simple)
      .optionallyWith(raw.map(value => value.buildAwsValue()))(_.raw)
      .optionallyWith(template.map(value => value.buildAwsValue()))(_.template)
      .build()
  }
  def asReadOnly: zio.aws.pinpointemail.model.EmailContent.ReadOnly =
    zio.aws.pinpointemail.model.EmailContent.wrap(buildAwsValue())
}
object EmailContent {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpointemail.model.EmailContent
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpointemail.model.EmailContent =
      zio.aws.pinpointemail.model.EmailContent(
        simple.map(value => value.asEditable),
        raw.map(value => value.asEditable),
        template.map(value => value.asEditable)
      )
    def simple: Optional[zio.aws.pinpointemail.model.Message.ReadOnly]
    def raw: Optional[zio.aws.pinpointemail.model.RawMessage.ReadOnly]
    def template: Optional[zio.aws.pinpointemail.model.Template.ReadOnly]
    def getSimple
        : ZIO[Any, AwsError, zio.aws.pinpointemail.model.Message.ReadOnly] =
      AwsError.unwrapOptionField("simple", simple)
    def getRaw
        : ZIO[Any, AwsError, zio.aws.pinpointemail.model.RawMessage.ReadOnly] =
      AwsError.unwrapOptionField("raw", raw)
    def getTemplate
        : ZIO[Any, AwsError, zio.aws.pinpointemail.model.Template.ReadOnly] =
      AwsError.unwrapOptionField("template", template)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpointemail.model.EmailContent
  ) extends zio.aws.pinpointemail.model.EmailContent.ReadOnly {
    override val simple
        : Optional[zio.aws.pinpointemail.model.Message.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.simple())
        .map(value => zio.aws.pinpointemail.model.Message.wrap(value))
    override val raw
        : Optional[zio.aws.pinpointemail.model.RawMessage.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.raw())
        .map(value => zio.aws.pinpointemail.model.RawMessage.wrap(value))
    override val template
        : Optional[zio.aws.pinpointemail.model.Template.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.template())
        .map(value => zio.aws.pinpointemail.model.Template.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpointemail.model.EmailContent
  ): zio.aws.pinpointemail.model.EmailContent.ReadOnly = new Wrapper(impl)
}
