package zio.aws.pinpointemail.model
import scala.jdk.CollectionConverters._
sealed trait DkimStatus {
  def unwrap: software.amazon.awssdk.services.pinpointemail.model.DkimStatus
}
object DkimStatus {
  def wrap(
      value: software.amazon.awssdk.services.pinpointemail.model.DkimStatus
  ): zio.aws.pinpointemail.model.DkimStatus = value match {
    case software.amazon.awssdk.services.pinpointemail.model.DkimStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.pinpointemail.model.DkimStatus.PENDING =>
      val r = PENDING
      r
    case software.amazon.awssdk.services.pinpointemail.model.DkimStatus.SUCCESS =>
      val r = SUCCESS
      r
    case software.amazon.awssdk.services.pinpointemail.model.DkimStatus.FAILED =>
      val r = FAILED
      r
    case software.amazon.awssdk.services.pinpointemail.model.DkimStatus.TEMPORARY_FAILURE =>
      val r = TEMPORARY_FAILURE
      r
    case software.amazon.awssdk.services.pinpointemail.model.DkimStatus.NOT_STARTED =>
      val r = NOT_STARTED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.pinpointemail.model.DkimStatus {
    override def unwrap
        : software.amazon.awssdk.services.pinpointemail.model.DkimStatus =
      software.amazon.awssdk.services.pinpointemail.model.DkimStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object PENDING extends zio.aws.pinpointemail.model.DkimStatus {
    override def unwrap
        : software.amazon.awssdk.services.pinpointemail.model.DkimStatus =
      software.amazon.awssdk.services.pinpointemail.model.DkimStatus.PENDING
  }
  case object SUCCESS extends zio.aws.pinpointemail.model.DkimStatus {
    override def unwrap
        : software.amazon.awssdk.services.pinpointemail.model.DkimStatus =
      software.amazon.awssdk.services.pinpointemail.model.DkimStatus.SUCCESS
  }
  case object FAILED extends zio.aws.pinpointemail.model.DkimStatus {
    override def unwrap
        : software.amazon.awssdk.services.pinpointemail.model.DkimStatus =
      software.amazon.awssdk.services.pinpointemail.model.DkimStatus.FAILED
  }
  case object TEMPORARY_FAILURE extends zio.aws.pinpointemail.model.DkimStatus {
    override def unwrap
        : software.amazon.awssdk.services.pinpointemail.model.DkimStatus =
      software.amazon.awssdk.services.pinpointemail.model.DkimStatus.TEMPORARY_FAILURE
  }
  case object NOT_STARTED extends zio.aws.pinpointemail.model.DkimStatus {
    override def unwrap
        : software.amazon.awssdk.services.pinpointemail.model.DkimStatus =
      software.amazon.awssdk.services.pinpointemail.model.DkimStatus.NOT_STARTED
  }
}
