package zio.aws.pinpointemail.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpointemail.model.primitives.{Enabled, Identity}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class PutEmailIdentityFeedbackAttributesRequest(
    emailIdentity: Identity,
    emailForwardingEnabled: Optional[Enabled] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpointemail.model.PutEmailIdentityFeedbackAttributesRequest = {
    import PutEmailIdentityFeedbackAttributesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpointemail.model.PutEmailIdentityFeedbackAttributesRequest
      .builder()
      .emailIdentity(Identity.unwrap(emailIdentity): java.lang.String)
      .optionallyWith(
        emailForwardingEnabled.map(value =>
          Enabled.unwrap(value): java.lang.Boolean
        )
      )(_.emailForwardingEnabled)
      .build()
  }
  def asReadOnly
      : zio.aws.pinpointemail.model.PutEmailIdentityFeedbackAttributesRequest.ReadOnly =
    zio.aws.pinpointemail.model.PutEmailIdentityFeedbackAttributesRequest
      .wrap(buildAwsValue())
}
object PutEmailIdentityFeedbackAttributesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpointemail.model.PutEmailIdentityFeedbackAttributesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.pinpointemail.model.PutEmailIdentityFeedbackAttributesRequest =
      zio.aws.pinpointemail.model.PutEmailIdentityFeedbackAttributesRequest(
        emailIdentity,
        emailForwardingEnabled.map(value => value)
      )
    def emailIdentity: Identity
    def emailForwardingEnabled: Optional[Enabled]
    def getEmailIdentity: ZIO[Any, Nothing, Identity] =
      ZIO.succeed(emailIdentity)
    def getEmailForwardingEnabled: ZIO[Any, AwsError, Enabled] = AwsError
      .unwrapOptionField("emailForwardingEnabled", emailForwardingEnabled)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpointemail.model.PutEmailIdentityFeedbackAttributesRequest
  ) extends zio.aws.pinpointemail.model.PutEmailIdentityFeedbackAttributesRequest.ReadOnly {
    override val emailIdentity: Identity =
      zio.aws.pinpointemail.model.primitives.Identity(impl.emailIdentity())
    override val emailForwardingEnabled: Optional[Enabled] =
      zio.aws.core.internal
        .optionalFromNullable(impl.emailForwardingEnabled())
        .map(value => zio.aws.pinpointemail.model.primitives.Enabled(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpointemail.model.PutEmailIdentityFeedbackAttributesRequest
  ): zio.aws.pinpointemail.model.PutEmailIdentityFeedbackAttributesRequest.ReadOnly =
    new Wrapper(impl)
}
