package zio.aws.pinpointemail.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class Message(
    subject: zio.aws.pinpointemail.model.Content,
    body: zio.aws.pinpointemail.model.Body
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpointemail.model.Message = {
    import Message.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpointemail.model.Message
      .builder()
      .subject(subject.buildAwsValue())
      .body(body.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.pinpointemail.model.Message.ReadOnly =
    zio.aws.pinpointemail.model.Message.wrap(buildAwsValue())
}
object Message {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpointemail.model.Message
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpointemail.model.Message =
      zio.aws.pinpointemail.model.Message(subject.asEditable, body.asEditable)
    def subject: zio.aws.pinpointemail.model.Content.ReadOnly
    def body: zio.aws.pinpointemail.model.Body.ReadOnly
    def getSubject
        : ZIO[Any, Nothing, zio.aws.pinpointemail.model.Content.ReadOnly] =
      ZIO.succeed(subject)
    def getBody: ZIO[Any, Nothing, zio.aws.pinpointemail.model.Body.ReadOnly] =
      ZIO.succeed(body)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpointemail.model.Message
  ) extends zio.aws.pinpointemail.model.Message.ReadOnly {
    override val subject: zio.aws.pinpointemail.model.Content.ReadOnly =
      zio.aws.pinpointemail.model.Content.wrap(impl.subject())
    override val body: zio.aws.pinpointemail.model.Body.ReadOnly =
      zio.aws.pinpointemail.model.Body.wrap(impl.body())
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpointemail.model.Message
  ): zio.aws.pinpointemail.model.Message.ReadOnly = new Wrapper(impl)
}
