package zio.aws.pinpointemail.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetDomainStatisticsReportResponse(
    overallVolume: zio.aws.pinpointemail.model.OverallVolume,
    dailyVolumes: Iterable[zio.aws.pinpointemail.model.DailyVolume]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpointemail.model.GetDomainStatisticsReportResponse = {
    import GetDomainStatisticsReportResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpointemail.model.GetDomainStatisticsReportResponse
      .builder()
      .overallVolume(overallVolume.buildAwsValue())
      .dailyVolumes(dailyVolumes.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.pinpointemail.model.GetDomainStatisticsReportResponse.ReadOnly =
    zio.aws.pinpointemail.model.GetDomainStatisticsReportResponse
      .wrap(buildAwsValue())
}
object GetDomainStatisticsReportResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpointemail.model.GetDomainStatisticsReportResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.pinpointemail.model.GetDomainStatisticsReportResponse =
      zio.aws.pinpointemail.model.GetDomainStatisticsReportResponse(
        overallVolume.asEditable,
        dailyVolumes.map { item =>
          item.asEditable
        }
      )
    def overallVolume: zio.aws.pinpointemail.model.OverallVolume.ReadOnly
    def dailyVolumes: List[zio.aws.pinpointemail.model.DailyVolume.ReadOnly]
    def getOverallVolume: ZIO[
      Any,
      Nothing,
      zio.aws.pinpointemail.model.OverallVolume.ReadOnly
    ] = ZIO.succeed(overallVolume)
    def getDailyVolumes: ZIO[Any, Nothing, List[
      zio.aws.pinpointemail.model.DailyVolume.ReadOnly
    ]] = ZIO.succeed(dailyVolumes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpointemail.model.GetDomainStatisticsReportResponse
  ) extends zio.aws.pinpointemail.model.GetDomainStatisticsReportResponse.ReadOnly {
    override val overallVolume
        : zio.aws.pinpointemail.model.OverallVolume.ReadOnly =
      zio.aws.pinpointemail.model.OverallVolume.wrap(impl.overallVolume())
    override val dailyVolumes
        : List[zio.aws.pinpointemail.model.DailyVolume.ReadOnly] = impl
      .dailyVolumes()
      .asScala
      .map { item =>
        zio.aws.pinpointemail.model.DailyVolume.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpointemail.model.GetDomainStatisticsReportResponse
  ): zio.aws.pinpointemail.model.GetDomainStatisticsReportResponse.ReadOnly =
    new Wrapper(impl)
}
