package zio.aws.pinpointemail.model
import zio.prelude.data.Optional
import zio.aws.pinpointemail.model.primitives.{MaxItems, NextToken, PoolName}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class GetDedicatedIpsRequest(
    poolName: Optional[PoolName] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    pageSize: Optional[MaxItems] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpointemail.model.GetDedicatedIpsRequest = {
    import GetDedicatedIpsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpointemail.model.GetDedicatedIpsRequest
      .builder()
      .optionallyWith(
        poolName.map(value => PoolName.unwrap(value): java.lang.String)
      )(_.poolName)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(pageSize.map(value => MaxItems.unwrap(value): Integer))(
        _.pageSize
      )
      .build()
  }
  def asReadOnly: zio.aws.pinpointemail.model.GetDedicatedIpsRequest.ReadOnly =
    zio.aws.pinpointemail.model.GetDedicatedIpsRequest.wrap(buildAwsValue())
}
object GetDedicatedIpsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpointemail.model.GetDedicatedIpsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpointemail.model.GetDedicatedIpsRequest =
      zio.aws.pinpointemail.model.GetDedicatedIpsRequest(
        poolName.map(value => value),
        nextToken.map(value => value),
        pageSize.map(value => value)
      )
    def poolName: Optional[PoolName]
    def nextToken: Optional[NextToken]
    def pageSize: Optional[MaxItems]
    def getPoolName: ZIO[Any, AwsError, PoolName] =
      AwsError.unwrapOptionField("poolName", poolName)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getPageSize: ZIO[Any, AwsError, MaxItems] =
      AwsError.unwrapOptionField("pageSize", pageSize)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpointemail.model.GetDedicatedIpsRequest
  ) extends zio.aws.pinpointemail.model.GetDedicatedIpsRequest.ReadOnly {
    override val poolName: Optional[PoolName] = zio.aws.core.internal
      .optionalFromNullable(impl.poolName())
      .map(value => zio.aws.pinpointemail.model.primitives.PoolName(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.pinpointemail.model.primitives.NextToken(value))
    override val pageSize: Optional[MaxItems] = zio.aws.core.internal
      .optionalFromNullable(impl.pageSize())
      .map(value => zio.aws.pinpointemail.model.primitives.MaxItems(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpointemail.model.GetDedicatedIpsRequest
  ): zio.aws.pinpointemail.model.GetDedicatedIpsRequest.ReadOnly = new Wrapper(
    impl
  )
}
