package zio.aws.pinpointemail.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpointemail.model.primitives.IspName
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class IspPlacement(
    ispName: Optional[IspName] = Optional.Absent,
    placementStatistics: Optional[
      zio.aws.pinpointemail.model.PlacementStatistics
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpointemail.model.IspPlacement = {
    import IspPlacement.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpointemail.model.IspPlacement
      .builder()
      .optionallyWith(
        ispName.map(value => IspName.unwrap(value): java.lang.String)
      )(_.ispName)
      .optionallyWith(placementStatistics.map(value => value.buildAwsValue()))(
        _.placementStatistics
      )
      .build()
  }
  def asReadOnly: zio.aws.pinpointemail.model.IspPlacement.ReadOnly =
    zio.aws.pinpointemail.model.IspPlacement.wrap(buildAwsValue())
}
object IspPlacement {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpointemail.model.IspPlacement
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpointemail.model.IspPlacement =
      zio.aws.pinpointemail.model.IspPlacement(
        ispName.map(value => value),
        placementStatistics.map(value => value.asEditable)
      )
    def ispName: Optional[IspName]
    def placementStatistics
        : Optional[zio.aws.pinpointemail.model.PlacementStatistics.ReadOnly]
    def getIspName: ZIO[Any, AwsError, IspName] =
      AwsError.unwrapOptionField("ispName", ispName)
    def getPlacementStatistics: ZIO[
      Any,
      AwsError,
      zio.aws.pinpointemail.model.PlacementStatistics.ReadOnly
    ] = AwsError.unwrapOptionField("placementStatistics", placementStatistics)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpointemail.model.IspPlacement
  ) extends zio.aws.pinpointemail.model.IspPlacement.ReadOnly {
    override val ispName: Optional[IspName] = zio.aws.core.internal
      .optionalFromNullable(impl.ispName())
      .map(value => zio.aws.pinpointemail.model.primitives.IspName(value))
    override val placementStatistics
        : Optional[zio.aws.pinpointemail.model.PlacementStatistics.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.placementStatistics())
        .map(value =>
          zio.aws.pinpointemail.model.PlacementStatistics.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpointemail.model.IspPlacement
  ): zio.aws.pinpointemail.model.IspPlacement.ReadOnly = new Wrapper(impl)
}
