package zio.aws.pinpointemail.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpointemail.model.primitives.EmailAddress
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Destination(
    toAddresses: Optional[Iterable[EmailAddress]] = Optional.Absent,
    ccAddresses: Optional[Iterable[EmailAddress]] = Optional.Absent,
    bccAddresses: Optional[Iterable[EmailAddress]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpointemail.model.Destination = {
    import Destination.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpointemail.model.Destination
      .builder()
      .optionallyWith(
        toAddresses.map(value =>
          value.map { item =>
            EmailAddress.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.toAddresses)
      .optionallyWith(
        ccAddresses.map(value =>
          value.map { item =>
            EmailAddress.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.ccAddresses)
      .optionallyWith(
        bccAddresses.map(value =>
          value.map { item =>
            EmailAddress.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.bccAddresses)
      .build()
  }
  def asReadOnly: zio.aws.pinpointemail.model.Destination.ReadOnly =
    zio.aws.pinpointemail.model.Destination.wrap(buildAwsValue())
}
object Destination {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpointemail.model.Destination
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpointemail.model.Destination =
      zio.aws.pinpointemail.model.Destination(
        toAddresses.map(value => value),
        ccAddresses.map(value => value),
        bccAddresses.map(value => value)
      )
    def toAddresses: Optional[List[EmailAddress]]
    def ccAddresses: Optional[List[EmailAddress]]
    def bccAddresses: Optional[List[EmailAddress]]
    def getToAddresses: ZIO[Any, AwsError, List[EmailAddress]] =
      AwsError.unwrapOptionField("toAddresses", toAddresses)
    def getCcAddresses: ZIO[Any, AwsError, List[EmailAddress]] =
      AwsError.unwrapOptionField("ccAddresses", ccAddresses)
    def getBccAddresses: ZIO[Any, AwsError, List[EmailAddress]] =
      AwsError.unwrapOptionField("bccAddresses", bccAddresses)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpointemail.model.Destination
  ) extends zio.aws.pinpointemail.model.Destination.ReadOnly {
    override val toAddresses: Optional[List[EmailAddress]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.toAddresses())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.pinpointemail.model.primitives.EmailAddress(item)
          }.toList
        )
    override val ccAddresses: Optional[List[EmailAddress]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ccAddresses())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.pinpointemail.model.primitives.EmailAddress(item)
          }.toList
        )
    override val bccAddresses: Optional[List[EmailAddress]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.bccAddresses())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.pinpointemail.model.primitives.EmailAddress(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpointemail.model.Destination
  ): zio.aws.pinpointemail.model.Destination.ReadOnly = new Wrapper(impl)
}
