package zio.aws.pinpointemail.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpointemail.model.primitives.Percentage
import scala.jdk.CollectionConverters._
final case class OverallVolume(
    volumeStatistics: Option[zio.aws.pinpointemail.model.VolumeStatistics] =
      None,
    readRatePercent: Option[Percentage] = None,
    domainIspPlacements: Option[
      Iterable[zio.aws.pinpointemail.model.DomainIspPlacement]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpointemail.model.OverallVolume = {
    import OverallVolume.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpointemail.model.OverallVolume
      .builder()
      .optionallyWith(volumeStatistics.map(value => value.buildAwsValue()))(
        _.volumeStatistics
      )
      .optionallyWith(
        readRatePercent.map(value => Percentage.unwrap(value): java.lang.Double)
      )(_.readRatePercent)
      .optionallyWith(
        domainIspPlacements.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.domainIspPlacements)
      .build()
  }
  def asReadOnly: zio.aws.pinpointemail.model.OverallVolume.ReadOnly =
    zio.aws.pinpointemail.model.OverallVolume.wrap(buildAwsValue())
}
object OverallVolume {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpointemail.model.OverallVolume
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpointemail.model.OverallVolume =
      zio.aws.pinpointemail.model.OverallVolume(
        volumeStatistics.map(value => value.asEditable),
        readRatePercent.map(value => value),
        domainIspPlacements.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def volumeStatistics
        : Option[zio.aws.pinpointemail.model.VolumeStatistics.ReadOnly]
    def readRatePercent: Option[Percentage]
    def domainIspPlacements
        : Option[List[zio.aws.pinpointemail.model.DomainIspPlacement.ReadOnly]]
    def getVolumeStatistics: ZIO[
      Any,
      AwsError,
      zio.aws.pinpointemail.model.VolumeStatistics.ReadOnly
    ] = AwsError.unwrapOptionField("volumeStatistics", volumeStatistics)
    def getReadRatePercent: ZIO[Any, AwsError, Percentage] =
      AwsError.unwrapOptionField("readRatePercent", readRatePercent)
    def getDomainIspPlacements: ZIO[Any, AwsError, List[
      zio.aws.pinpointemail.model.DomainIspPlacement.ReadOnly
    ]] = AwsError.unwrapOptionField("domainIspPlacements", domainIspPlacements)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpointemail.model.OverallVolume
  ) extends zio.aws.pinpointemail.model.OverallVolume.ReadOnly {
    override val volumeStatistics
        : Option[zio.aws.pinpointemail.model.VolumeStatistics.ReadOnly] = scala
      .Option(impl.volumeStatistics())
      .map(value => zio.aws.pinpointemail.model.VolumeStatistics.wrap(value))
    override val readRatePercent: Option[Percentage] = scala
      .Option(impl.readRatePercent())
      .map(value => zio.aws.pinpointemail.model.primitives.Percentage(value))
    override val domainIspPlacements: Option[
      List[zio.aws.pinpointemail.model.DomainIspPlacement.ReadOnly]
    ] = scala
      .Option(impl.domainIspPlacements())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.pinpointemail.model.DomainIspPlacement.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpointemail.model.OverallVolume
  ): zio.aws.pinpointemail.model.OverallVolume.ReadOnly = new Wrapper(impl)
}
