package zio.aws.pinpointemail.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpointemail.model.primitives.NextToken
import scala.jdk.CollectionConverters._
final case class GetDedicatedIpsResponse(
    dedicatedIps: Option[Iterable[zio.aws.pinpointemail.model.DedicatedIp]] =
      None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpointemail.model.GetDedicatedIpsResponse = {
    import GetDedicatedIpsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpointemail.model.GetDedicatedIpsResponse
      .builder()
      .optionallyWith(
        dedicatedIps.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.dedicatedIps)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.pinpointemail.model.GetDedicatedIpsResponse.ReadOnly =
    zio.aws.pinpointemail.model.GetDedicatedIpsResponse.wrap(buildAwsValue())
}
object GetDedicatedIpsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpointemail.model.GetDedicatedIpsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpointemail.model.GetDedicatedIpsResponse =
      zio.aws.pinpointemail.model.GetDedicatedIpsResponse(
        dedicatedIps.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def dedicatedIps
        : Option[List[zio.aws.pinpointemail.model.DedicatedIp.ReadOnly]]
    def nextToken: Option[NextToken]
    def getDedicatedIps: ZIO[Any, AwsError, List[
      zio.aws.pinpointemail.model.DedicatedIp.ReadOnly
    ]] = AwsError.unwrapOptionField("dedicatedIps", dedicatedIps)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpointemail.model.GetDedicatedIpsResponse
  ) extends zio.aws.pinpointemail.model.GetDedicatedIpsResponse.ReadOnly {
    override val dedicatedIps
        : Option[List[zio.aws.pinpointemail.model.DedicatedIp.ReadOnly]] = scala
      .Option(impl.dedicatedIps())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.pinpointemail.model.DedicatedIp.wrap(item)
        }.toList
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.pinpointemail.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpointemail.model.GetDedicatedIpsResponse
  ): zio.aws.pinpointemail.model.GetDedicatedIpsResponse.ReadOnly = new Wrapper(
    impl
  )
}
