package zio.aws.pinpointemail.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.pinpointemail.model.primitives.{Timestamp, Identity}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class GetDomainStatisticsReportRequest(
    domain: Identity,
    startDate: Timestamp,
    endDate: Timestamp
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpointemail.model.GetDomainStatisticsReportRequest = {
    import GetDomainStatisticsReportRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpointemail.model.GetDomainStatisticsReportRequest
      .builder()
      .domain(Identity.unwrap(domain): java.lang.String)
      .startDate(Timestamp.unwrap(startDate): Instant)
      .endDate(Timestamp.unwrap(endDate): Instant)
      .build()
  }
  def asReadOnly
      : zio.aws.pinpointemail.model.GetDomainStatisticsReportRequest.ReadOnly =
    zio.aws.pinpointemail.model.GetDomainStatisticsReportRequest
      .wrap(buildAwsValue())
}
object GetDomainStatisticsReportRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpointemail.model.GetDomainStatisticsReportRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.pinpointemail.model.GetDomainStatisticsReportRequest =
      zio.aws.pinpointemail.model
        .GetDomainStatisticsReportRequest(domain, startDate, endDate)
    def domain: Identity
    def startDate: Timestamp
    def endDate: Timestamp
    def getDomain: ZIO[Any, Nothing, Identity] = ZIO.succeed(domain)
    def getStartDate: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(startDate)
    def getEndDate: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(endDate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpointemail.model.GetDomainStatisticsReportRequest
  ) extends zio.aws.pinpointemail.model.GetDomainStatisticsReportRequest.ReadOnly {
    override val domain: Identity =
      zio.aws.pinpointemail.model.primitives.Identity(impl.domain())
    override val startDate: Timestamp =
      zio.aws.pinpointemail.model.primitives.Timestamp(impl.startDate())
    override val endDate: Timestamp =
      zio.aws.pinpointemail.model.primitives.Timestamp(impl.endDate())
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpointemail.model.GetDomainStatisticsReportRequest
  ): zio.aws.pinpointemail.model.GetDomainStatisticsReportRequest.ReadOnly =
    new Wrapper(impl)
}
