package zio.aws.pinpointemail.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpointemail.model.primitives.Percentage
import scala.jdk.CollectionConverters._
final case class PlacementStatistics(
    inboxPercentage: Option[Percentage] = None,
    spamPercentage: Option[Percentage] = None,
    missingPercentage: Option[Percentage] = None,
    spfPercentage: Option[Percentage] = None,
    dkimPercentage: Option[Percentage] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpointemail.model.PlacementStatistics = {
    import PlacementStatistics.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpointemail.model.PlacementStatistics
      .builder()
      .optionallyWith(
        inboxPercentage.map(value => Percentage.unwrap(value): java.lang.Double)
      )(_.inboxPercentage)
      .optionallyWith(
        spamPercentage.map(value => Percentage.unwrap(value): java.lang.Double)
      )(_.spamPercentage)
      .optionallyWith(
        missingPercentage.map(value =>
          Percentage.unwrap(value): java.lang.Double
        )
      )(_.missingPercentage)
      .optionallyWith(
        spfPercentage.map(value => Percentage.unwrap(value): java.lang.Double)
      )(_.spfPercentage)
      .optionallyWith(
        dkimPercentage.map(value => Percentage.unwrap(value): java.lang.Double)
      )(_.dkimPercentage)
      .build()
  }
  def asReadOnly: zio.aws.pinpointemail.model.PlacementStatistics.ReadOnly =
    zio.aws.pinpointemail.model.PlacementStatistics.wrap(buildAwsValue())
}
object PlacementStatistics {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpointemail.model.PlacementStatistics
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpointemail.model.PlacementStatistics =
      zio.aws.pinpointemail.model.PlacementStatistics(
        inboxPercentage.map(value => value),
        spamPercentage.map(value => value),
        missingPercentage.map(value => value),
        spfPercentage.map(value => value),
        dkimPercentage.map(value => value)
      )
    def inboxPercentage: Option[Percentage]
    def spamPercentage: Option[Percentage]
    def missingPercentage: Option[Percentage]
    def spfPercentage: Option[Percentage]
    def dkimPercentage: Option[Percentage]
    def getInboxPercentage: ZIO[Any, AwsError, Percentage] =
      AwsError.unwrapOptionField("inboxPercentage", inboxPercentage)
    def getSpamPercentage: ZIO[Any, AwsError, Percentage] =
      AwsError.unwrapOptionField("spamPercentage", spamPercentage)
    def getMissingPercentage: ZIO[Any, AwsError, Percentage] =
      AwsError.unwrapOptionField("missingPercentage", missingPercentage)
    def getSpfPercentage: ZIO[Any, AwsError, Percentage] =
      AwsError.unwrapOptionField("spfPercentage", spfPercentage)
    def getDkimPercentage: ZIO[Any, AwsError, Percentage] =
      AwsError.unwrapOptionField("dkimPercentage", dkimPercentage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpointemail.model.PlacementStatistics
  ) extends zio.aws.pinpointemail.model.PlacementStatistics.ReadOnly {
    override val inboxPercentage: Option[Percentage] = scala
      .Option(impl.inboxPercentage())
      .map(value => zio.aws.pinpointemail.model.primitives.Percentage(value))
    override val spamPercentage: Option[Percentage] = scala
      .Option(impl.spamPercentage())
      .map(value => zio.aws.pinpointemail.model.primitives.Percentage(value))
    override val missingPercentage: Option[Percentage] = scala
      .Option(impl.missingPercentage())
      .map(value => zio.aws.pinpointemail.model.primitives.Percentage(value))
    override val spfPercentage: Option[Percentage] = scala
      .Option(impl.spfPercentage())
      .map(value => zio.aws.pinpointemail.model.primitives.Percentage(value))
    override val dkimPercentage: Option[Percentage] = scala
      .Option(impl.dkimPercentage())
      .map(value => zio.aws.pinpointemail.model.primitives.Percentage(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpointemail.model.PlacementStatistics
  ): zio.aws.pinpointemail.model.PlacementStatistics.ReadOnly = new Wrapper(
    impl
  )
}
