package zio.aws.pinpointemail.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpointemail.model.primitives.{Timestamp, Enabled}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class GetDeliverabilityDashboardOptionsResponse(
    dashboardEnabled: Enabled,
    subscriptionExpiryDate: Option[Timestamp] = None,
    accountStatus: Option[
      zio.aws.pinpointemail.model.DeliverabilityDashboardAccountStatus
    ] = None,
    activeSubscribedDomains: Option[
      Iterable[zio.aws.pinpointemail.model.DomainDeliverabilityTrackingOption]
    ] = None,
    pendingExpirationSubscribedDomains: Option[
      Iterable[zio.aws.pinpointemail.model.DomainDeliverabilityTrackingOption]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpointemail.model.GetDeliverabilityDashboardOptionsResponse = {
    import GetDeliverabilityDashboardOptionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpointemail.model.GetDeliverabilityDashboardOptionsResponse
      .builder()
      .dashboardEnabled(Enabled.unwrap(dashboardEnabled): java.lang.Boolean)
      .optionallyWith(
        subscriptionExpiryDate.map(value => Timestamp.unwrap(value): Instant)
      )(_.subscriptionExpiryDate)
      .optionallyWith(accountStatus.map(value => value.unwrap))(_.accountStatus)
      .optionallyWith(
        activeSubscribedDomains.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.activeSubscribedDomains)
      .optionallyWith(
        pendingExpirationSubscribedDomains.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.pendingExpirationSubscribedDomains)
      .build()
  }
  def asReadOnly
      : zio.aws.pinpointemail.model.GetDeliverabilityDashboardOptionsResponse.ReadOnly =
    zio.aws.pinpointemail.model.GetDeliverabilityDashboardOptionsResponse
      .wrap(buildAwsValue())
}
object GetDeliverabilityDashboardOptionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpointemail.model.GetDeliverabilityDashboardOptionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.pinpointemail.model.GetDeliverabilityDashboardOptionsResponse =
      zio.aws.pinpointemail.model.GetDeliverabilityDashboardOptionsResponse(
        dashboardEnabled,
        subscriptionExpiryDate.map(value => value),
        accountStatus.map(value => value),
        activeSubscribedDomains.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        pendingExpirationSubscribedDomains.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def dashboardEnabled: Enabled
    def subscriptionExpiryDate: Option[Timestamp]
    def accountStatus: Option[
      zio.aws.pinpointemail.model.DeliverabilityDashboardAccountStatus
    ]
    def activeSubscribedDomains: Option[List[
      zio.aws.pinpointemail.model.DomainDeliverabilityTrackingOption.ReadOnly
    ]]
    def pendingExpirationSubscribedDomains: Option[List[
      zio.aws.pinpointemail.model.DomainDeliverabilityTrackingOption.ReadOnly
    ]]
    def getDashboardEnabled: ZIO[Any, Nothing, Enabled] =
      ZIO.succeed(dashboardEnabled)
    def getSubscriptionExpiryDate: ZIO[Any, AwsError, Timestamp] = AwsError
      .unwrapOptionField("subscriptionExpiryDate", subscriptionExpiryDate)
    def getAccountStatus: ZIO[
      Any,
      AwsError,
      zio.aws.pinpointemail.model.DeliverabilityDashboardAccountStatus
    ] = AwsError.unwrapOptionField("accountStatus", accountStatus)
    def getActiveSubscribedDomains: ZIO[Any, AwsError, List[
      zio.aws.pinpointemail.model.DomainDeliverabilityTrackingOption.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "activeSubscribedDomains",
      activeSubscribedDomains
    )
    def getPendingExpirationSubscribedDomains: ZIO[Any, AwsError, List[
      zio.aws.pinpointemail.model.DomainDeliverabilityTrackingOption.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "pendingExpirationSubscribedDomains",
      pendingExpirationSubscribedDomains
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpointemail.model.GetDeliverabilityDashboardOptionsResponse
  ) extends zio.aws.pinpointemail.model.GetDeliverabilityDashboardOptionsResponse.ReadOnly {
    override val dashboardEnabled: Enabled =
      zio.aws.pinpointemail.model.primitives.Enabled(impl.dashboardEnabled())
    override val subscriptionExpiryDate: Option[Timestamp] = scala
      .Option(impl.subscriptionExpiryDate())
      .map(value => zio.aws.pinpointemail.model.primitives.Timestamp(value))
    override val accountStatus: Option[
      zio.aws.pinpointemail.model.DeliverabilityDashboardAccountStatus
    ] = scala
      .Option(impl.accountStatus())
      .map(value =>
        zio.aws.pinpointemail.model.DeliverabilityDashboardAccountStatus
          .wrap(value)
      )
    override val activeSubscribedDomains: Option[List[
      zio.aws.pinpointemail.model.DomainDeliverabilityTrackingOption.ReadOnly
    ]] = scala
      .Option(impl.activeSubscribedDomains())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.pinpointemail.model.DomainDeliverabilityTrackingOption
            .wrap(item)
        }.toList
      )
    override val pendingExpirationSubscribedDomains: Option[List[
      zio.aws.pinpointemail.model.DomainDeliverabilityTrackingOption.ReadOnly
    ]] = scala
      .Option(impl.pendingExpirationSubscribedDomains())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.pinpointemail.model.DomainDeliverabilityTrackingOption
            .wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpointemail.model.GetDeliverabilityDashboardOptionsResponse
  ): zio.aws.pinpointemail.model.GetDeliverabilityDashboardOptionsResponse.ReadOnly =
    new Wrapper(impl)
}
