package zio.aws.pinpointemail.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpointemail.model.primitives.{
  EmailAddress,
  ReportId,
  Timestamp,
  ReportName,
  DeliverabilityTestSubject
}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class DeliverabilityTestReport(
    reportId: Option[ReportId] = None,
    reportName: Option[ReportName] = None,
    subject: Option[DeliverabilityTestSubject] = None,
    fromEmailAddress: Option[EmailAddress] = None,
    createDate: Option[Timestamp] = None,
    deliverabilityTestStatus: Option[
      zio.aws.pinpointemail.model.DeliverabilityTestStatus
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpointemail.model.DeliverabilityTestReport = {
    import DeliverabilityTestReport.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpointemail.model.DeliverabilityTestReport
      .builder()
      .optionallyWith(
        reportId.map(value => ReportId.unwrap(value): java.lang.String)
      )(_.reportId)
      .optionallyWith(
        reportName.map(value => ReportName.unwrap(value): java.lang.String)
      )(_.reportName)
      .optionallyWith(
        subject.map(value =>
          DeliverabilityTestSubject.unwrap(value): java.lang.String
        )
      )(_.subject)
      .optionallyWith(
        fromEmailAddress.map(value =>
          EmailAddress.unwrap(value): java.lang.String
        )
      )(_.fromEmailAddress)
      .optionallyWith(
        createDate.map(value => Timestamp.unwrap(value): Instant)
      )(_.createDate)
      .optionallyWith(deliverabilityTestStatus.map(value => value.unwrap))(
        _.deliverabilityTestStatus
      )
      .build()
  }
  def asReadOnly
      : zio.aws.pinpointemail.model.DeliverabilityTestReport.ReadOnly =
    zio.aws.pinpointemail.model.DeliverabilityTestReport.wrap(buildAwsValue())
}
object DeliverabilityTestReport {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpointemail.model.DeliverabilityTestReport
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpointemail.model.DeliverabilityTestReport =
      zio.aws.pinpointemail.model.DeliverabilityTestReport(
        reportId.map(value => value),
        reportName.map(value => value),
        subject.map(value => value),
        fromEmailAddress.map(value => value),
        createDate.map(value => value),
        deliverabilityTestStatus.map(value => value)
      )
    def reportId: Option[ReportId]
    def reportName: Option[ReportName]
    def subject: Option[DeliverabilityTestSubject]
    def fromEmailAddress: Option[EmailAddress]
    def createDate: Option[Timestamp]
    def deliverabilityTestStatus
        : Option[zio.aws.pinpointemail.model.DeliverabilityTestStatus]
    def getReportId: ZIO[Any, AwsError, ReportId] =
      AwsError.unwrapOptionField("reportId", reportId)
    def getReportName: ZIO[Any, AwsError, ReportName] =
      AwsError.unwrapOptionField("reportName", reportName)
    def getSubject: ZIO[Any, AwsError, DeliverabilityTestSubject] =
      AwsError.unwrapOptionField("subject", subject)
    def getFromEmailAddress: ZIO[Any, AwsError, EmailAddress] =
      AwsError.unwrapOptionField("fromEmailAddress", fromEmailAddress)
    def getCreateDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createDate", createDate)
    def getDeliverabilityTestStatus: ZIO[
      Any,
      AwsError,
      zio.aws.pinpointemail.model.DeliverabilityTestStatus
    ] = AwsError.unwrapOptionField(
      "deliverabilityTestStatus",
      deliverabilityTestStatus
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpointemail.model.DeliverabilityTestReport
  ) extends zio.aws.pinpointemail.model.DeliverabilityTestReport.ReadOnly {
    override val reportId: Option[ReportId] = scala
      .Option(impl.reportId())
      .map(value => zio.aws.pinpointemail.model.primitives.ReportId(value))
    override val reportName: Option[ReportName] = scala
      .Option(impl.reportName())
      .map(value => zio.aws.pinpointemail.model.primitives.ReportName(value))
    override val subject: Option[DeliverabilityTestSubject] = scala
      .Option(impl.subject())
      .map(value =>
        zio.aws.pinpointemail.model.primitives.DeliverabilityTestSubject(value)
      )
    override val fromEmailAddress: Option[EmailAddress] = scala
      .Option(impl.fromEmailAddress())
      .map(value => zio.aws.pinpointemail.model.primitives.EmailAddress(value))
    override val createDate: Option[Timestamp] = scala
      .Option(impl.createDate())
      .map(value => zio.aws.pinpointemail.model.primitives.Timestamp(value))
    override val deliverabilityTestStatus
        : Option[zio.aws.pinpointemail.model.DeliverabilityTestStatus] = scala
      .Option(impl.deliverabilityTestStatus())
      .map(value =>
        zio.aws.pinpointemail.model.DeliverabilityTestStatus.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpointemail.model.DeliverabilityTestReport
  ): zio.aws.pinpointemail.model.DeliverabilityTestReport.ReadOnly =
    new Wrapper(impl)
}
