package zio.aws.pinpointemail.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpointemail.model.primitives.{EmailAddress, ReportName}
import scala.jdk.CollectionConverters._
final case class CreateDeliverabilityTestReportRequest(
    reportName: Option[ReportName] = None,
    fromEmailAddress: EmailAddress,
    content: zio.aws.pinpointemail.model.EmailContent,
    tags: Option[Iterable[zio.aws.pinpointemail.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpointemail.model.CreateDeliverabilityTestReportRequest = {
    import CreateDeliverabilityTestReportRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpointemail.model.CreateDeliverabilityTestReportRequest
      .builder()
      .optionallyWith(
        reportName.map(value => ReportName.unwrap(value): java.lang.String)
      )(_.reportName)
      .fromEmailAddress(EmailAddress.unwrap(fromEmailAddress): java.lang.String)
      .content(content.buildAwsValue())
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.pinpointemail.model.CreateDeliverabilityTestReportRequest.ReadOnly =
    zio.aws.pinpointemail.model.CreateDeliverabilityTestReportRequest
      .wrap(buildAwsValue())
}
object CreateDeliverabilityTestReportRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpointemail.model.CreateDeliverabilityTestReportRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.pinpointemail.model.CreateDeliverabilityTestReportRequest =
      zio.aws.pinpointemail.model.CreateDeliverabilityTestReportRequest(
        reportName.map(value => value),
        fromEmailAddress,
        content.asEditable,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def reportName: Option[ReportName]
    def fromEmailAddress: EmailAddress
    def content: zio.aws.pinpointemail.model.EmailContent.ReadOnly
    def tags: Option[List[zio.aws.pinpointemail.model.Tag.ReadOnly]]
    def getReportName: ZIO[Any, AwsError, ReportName] =
      AwsError.unwrapOptionField("reportName", reportName)
    def getFromEmailAddress: ZIO[Any, Nothing, EmailAddress] =
      ZIO.succeed(fromEmailAddress)
    def getContent
        : ZIO[Any, Nothing, zio.aws.pinpointemail.model.EmailContent.ReadOnly] =
      ZIO.succeed(content)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.pinpointemail.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpointemail.model.CreateDeliverabilityTestReportRequest
  ) extends zio.aws.pinpointemail.model.CreateDeliverabilityTestReportRequest.ReadOnly {
    override val reportName: Option[ReportName] = scala
      .Option(impl.reportName())
      .map(value => zio.aws.pinpointemail.model.primitives.ReportName(value))
    override val fromEmailAddress: EmailAddress =
      zio.aws.pinpointemail.model.primitives
        .EmailAddress(impl.fromEmailAddress())
    override val content: zio.aws.pinpointemail.model.EmailContent.ReadOnly =
      zio.aws.pinpointemail.model.EmailContent.wrap(impl.content())
    override val tags: Option[List[zio.aws.pinpointemail.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.pinpointemail.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpointemail.model.CreateDeliverabilityTestReportRequest
  ): zio.aws.pinpointemail.model.CreateDeliverabilityTestReportRequest.ReadOnly =
    new Wrapper(impl)
}
