package zio.aws.pinpointemail.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpointemail.model.primitives.ConfigurationSetName
import scala.jdk.CollectionConverters._
final case class CreateConfigurationSetRequest(
    configurationSetName: ConfigurationSetName,
    trackingOptions: Option[zio.aws.pinpointemail.model.TrackingOptions] = None,
    deliveryOptions: Option[zio.aws.pinpointemail.model.DeliveryOptions] = None,
    reputationOptions: Option[zio.aws.pinpointemail.model.ReputationOptions] =
      None,
    sendingOptions: Option[zio.aws.pinpointemail.model.SendingOptions] = None,
    tags: Option[Iterable[zio.aws.pinpointemail.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpointemail.model.CreateConfigurationSetRequest = {
    import CreateConfigurationSetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpointemail.model.CreateConfigurationSetRequest
      .builder()
      .configurationSetName(
        ConfigurationSetName.unwrap(configurationSetName): java.lang.String
      )
      .optionallyWith(trackingOptions.map(value => value.buildAwsValue()))(
        _.trackingOptions
      )
      .optionallyWith(deliveryOptions.map(value => value.buildAwsValue()))(
        _.deliveryOptions
      )
      .optionallyWith(reputationOptions.map(value => value.buildAwsValue()))(
        _.reputationOptions
      )
      .optionallyWith(sendingOptions.map(value => value.buildAwsValue()))(
        _.sendingOptions
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.pinpointemail.model.CreateConfigurationSetRequest.ReadOnly =
    zio.aws.pinpointemail.model.CreateConfigurationSetRequest
      .wrap(buildAwsValue())
}
object CreateConfigurationSetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpointemail.model.CreateConfigurationSetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpointemail.model.CreateConfigurationSetRequest =
      zio.aws.pinpointemail.model.CreateConfigurationSetRequest(
        configurationSetName,
        trackingOptions.map(value => value.asEditable),
        deliveryOptions.map(value => value.asEditable),
        reputationOptions.map(value => value.asEditable),
        sendingOptions.map(value => value.asEditable),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def configurationSetName: ConfigurationSetName
    def trackingOptions
        : Option[zio.aws.pinpointemail.model.TrackingOptions.ReadOnly]
    def deliveryOptions
        : Option[zio.aws.pinpointemail.model.DeliveryOptions.ReadOnly]
    def reputationOptions
        : Option[zio.aws.pinpointemail.model.ReputationOptions.ReadOnly]
    def sendingOptions
        : Option[zio.aws.pinpointemail.model.SendingOptions.ReadOnly]
    def tags: Option[List[zio.aws.pinpointemail.model.Tag.ReadOnly]]
    def getConfigurationSetName: ZIO[Any, Nothing, ConfigurationSetName] =
      ZIO.succeed(configurationSetName)
    def getTrackingOptions: ZIO[
      Any,
      AwsError,
      zio.aws.pinpointemail.model.TrackingOptions.ReadOnly
    ] = AwsError.unwrapOptionField("trackingOptions", trackingOptions)
    def getDeliveryOptions: ZIO[
      Any,
      AwsError,
      zio.aws.pinpointemail.model.DeliveryOptions.ReadOnly
    ] = AwsError.unwrapOptionField("deliveryOptions", deliveryOptions)
    def getReputationOptions: ZIO[
      Any,
      AwsError,
      zio.aws.pinpointemail.model.ReputationOptions.ReadOnly
    ] = AwsError.unwrapOptionField("reputationOptions", reputationOptions)
    def getSendingOptions: ZIO[
      Any,
      AwsError,
      zio.aws.pinpointemail.model.SendingOptions.ReadOnly
    ] = AwsError.unwrapOptionField("sendingOptions", sendingOptions)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.pinpointemail.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpointemail.model.CreateConfigurationSetRequest
  ) extends zio.aws.pinpointemail.model.CreateConfigurationSetRequest.ReadOnly {
    override val configurationSetName: ConfigurationSetName =
      zio.aws.pinpointemail.model.primitives
        .ConfigurationSetName(impl.configurationSetName())
    override val trackingOptions
        : Option[zio.aws.pinpointemail.model.TrackingOptions.ReadOnly] = scala
      .Option(impl.trackingOptions())
      .map(value => zio.aws.pinpointemail.model.TrackingOptions.wrap(value))
    override val deliveryOptions
        : Option[zio.aws.pinpointemail.model.DeliveryOptions.ReadOnly] = scala
      .Option(impl.deliveryOptions())
      .map(value => zio.aws.pinpointemail.model.DeliveryOptions.wrap(value))
    override val reputationOptions
        : Option[zio.aws.pinpointemail.model.ReputationOptions.ReadOnly] = scala
      .Option(impl.reputationOptions())
      .map(value => zio.aws.pinpointemail.model.ReputationOptions.wrap(value))
    override val sendingOptions
        : Option[zio.aws.pinpointemail.model.SendingOptions.ReadOnly] = scala
      .Option(impl.sendingOptions())
      .map(value => zio.aws.pinpointemail.model.SendingOptions.wrap(value))
    override val tags: Option[List[zio.aws.pinpointemail.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.pinpointemail.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpointemail.model.CreateConfigurationSetRequest
  ): zio.aws.pinpointemail.model.CreateConfigurationSetRequest.ReadOnly =
    new Wrapper(impl)
}
