package zio.aws.pinpointemail.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.pinpointemail.model.primitives.AmazonResourceName
import scala.jdk.CollectionConverters._
final case class TagResourceRequest(
    resourceArn: AmazonResourceName,
    tags: Iterable[zio.aws.pinpointemail.model.Tag]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpointemail.model.TagResourceRequest = {
    import TagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpointemail.model.TagResourceRequest
      .builder()
      .resourceArn(AmazonResourceName.unwrap(resourceArn): java.lang.String)
      .tags(tags.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.pinpointemail.model.TagResourceRequest.ReadOnly =
    zio.aws.pinpointemail.model.TagResourceRequest.wrap(buildAwsValue())
}
object TagResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpointemail.model.TagResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpointemail.model.TagResourceRequest =
      zio.aws.pinpointemail.model.TagResourceRequest(
        resourceArn,
        tags.map { item =>
          item.asEditable
        }
      )
    def resourceArn: AmazonResourceName
    def tags: List[zio.aws.pinpointemail.model.Tag.ReadOnly]
    def getResourceArn: ZIO[Any, Nothing, AmazonResourceName] =
      ZIO.succeed(resourceArn)
    def getTags
        : ZIO[Any, Nothing, List[zio.aws.pinpointemail.model.Tag.ReadOnly]] =
      ZIO.succeed(tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpointemail.model.TagResourceRequest
  ) extends zio.aws.pinpointemail.model.TagResourceRequest.ReadOnly {
    override val resourceArn: AmazonResourceName =
      zio.aws.pinpointemail.model.primitives
        .AmazonResourceName(impl.resourceArn())
    override val tags: List[zio.aws.pinpointemail.model.Tag.ReadOnly] = impl
      .tags()
      .asScala
      .map { item =>
        zio.aws.pinpointemail.model.Tag.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpointemail.model.TagResourceRequest
  ): zio.aws.pinpointemail.model.TagResourceRequest.ReadOnly = new Wrapper(impl)
}
