package zio.aws.pinpointemail.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpointemail.model.primitives.Enabled
import scala.jdk.CollectionConverters._
final case class SendingOptions(sendingEnabled: Option[Enabled] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpointemail.model.SendingOptions = {
    import SendingOptions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpointemail.model.SendingOptions
      .builder()
      .optionallyWith(
        sendingEnabled.map(value => Enabled.unwrap(value): java.lang.Boolean)
      )(_.sendingEnabled)
      .build()
  }
  def asReadOnly: zio.aws.pinpointemail.model.SendingOptions.ReadOnly =
    zio.aws.pinpointemail.model.SendingOptions.wrap(buildAwsValue())
}
object SendingOptions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpointemail.model.SendingOptions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpointemail.model.SendingOptions =
      zio.aws.pinpointemail.model
        .SendingOptions(sendingEnabled.map(value => value))
    def sendingEnabled: Option[Enabled]
    def getSendingEnabled: ZIO[Any, AwsError, Enabled] =
      AwsError.unwrapOptionField("sendingEnabled", sendingEnabled)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpointemail.model.SendingOptions
  ) extends zio.aws.pinpointemail.model.SendingOptions.ReadOnly {
    override val sendingEnabled: Option[Enabled] = scala
      .Option(impl.sendingEnabled())
      .map(value => zio.aws.pinpointemail.model.primitives.Enabled(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpointemail.model.SendingOptions
  ): zio.aws.pinpointemail.model.SendingOptions.ReadOnly = new Wrapper(impl)
}
