package zio.aws.pinpointemail.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpointemail.model.primitives.{
  ConfigurationSetName,
  EmailAddress
}
import scala.jdk.CollectionConverters._
final case class SendEmailRequest(
    fromEmailAddress: Option[EmailAddress] = None,
    destination: zio.aws.pinpointemail.model.Destination,
    replyToAddresses: Option[Iterable[EmailAddress]] = None,
    feedbackForwardingEmailAddress: Option[EmailAddress] = None,
    content: zio.aws.pinpointemail.model.EmailContent,
    emailTags: Option[Iterable[zio.aws.pinpointemail.model.MessageTag]] = None,
    configurationSetName: Option[ConfigurationSetName] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpointemail.model.SendEmailRequest = {
    import SendEmailRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpointemail.model.SendEmailRequest
      .builder()
      .optionallyWith(
        fromEmailAddress.map(value =>
          EmailAddress.unwrap(value): java.lang.String
        )
      )(_.fromEmailAddress)
      .destination(destination.buildAwsValue())
      .optionallyWith(
        replyToAddresses.map(value =>
          value.map { item =>
            EmailAddress.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.replyToAddresses)
      .optionallyWith(
        feedbackForwardingEmailAddress.map(value =>
          EmailAddress.unwrap(value): java.lang.String
        )
      )(_.feedbackForwardingEmailAddress)
      .content(content.buildAwsValue())
      .optionallyWith(
        emailTags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.emailTags)
      .optionallyWith(
        configurationSetName.map(value =>
          ConfigurationSetName.unwrap(value): java.lang.String
        )
      )(_.configurationSetName)
      .build()
  }
  def asReadOnly: zio.aws.pinpointemail.model.SendEmailRequest.ReadOnly =
    zio.aws.pinpointemail.model.SendEmailRequest.wrap(buildAwsValue())
}
object SendEmailRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpointemail.model.SendEmailRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpointemail.model.SendEmailRequest =
      zio.aws.pinpointemail.model.SendEmailRequest(
        fromEmailAddress.map(value => value),
        destination.asEditable,
        replyToAddresses.map(value => value),
        feedbackForwardingEmailAddress.map(value => value),
        content.asEditable,
        emailTags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        configurationSetName.map(value => value)
      )
    def fromEmailAddress: Option[EmailAddress]
    def destination: zio.aws.pinpointemail.model.Destination.ReadOnly
    def replyToAddresses: Option[List[EmailAddress]]
    def feedbackForwardingEmailAddress: Option[EmailAddress]
    def content: zio.aws.pinpointemail.model.EmailContent.ReadOnly
    def emailTags: Option[List[zio.aws.pinpointemail.model.MessageTag.ReadOnly]]
    def configurationSetName: Option[ConfigurationSetName]
    def getFromEmailAddress: ZIO[Any, AwsError, EmailAddress] =
      AwsError.unwrapOptionField("fromEmailAddress", fromEmailAddress)
    def getDestination
        : ZIO[Any, Nothing, zio.aws.pinpointemail.model.Destination.ReadOnly] =
      ZIO.succeed(destination)
    def getReplyToAddresses: ZIO[Any, AwsError, List[EmailAddress]] =
      AwsError.unwrapOptionField("replyToAddresses", replyToAddresses)
    def getFeedbackForwardingEmailAddress: ZIO[Any, AwsError, EmailAddress] =
      AwsError.unwrapOptionField(
        "feedbackForwardingEmailAddress",
        feedbackForwardingEmailAddress
      )
    def getContent
        : ZIO[Any, Nothing, zio.aws.pinpointemail.model.EmailContent.ReadOnly] =
      ZIO.succeed(content)
    def getEmailTags: ZIO[Any, AwsError, List[
      zio.aws.pinpointemail.model.MessageTag.ReadOnly
    ]] = AwsError.unwrapOptionField("emailTags", emailTags)
    def getConfigurationSetName: ZIO[Any, AwsError, ConfigurationSetName] =
      AwsError.unwrapOptionField("configurationSetName", configurationSetName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpointemail.model.SendEmailRequest
  ) extends zio.aws.pinpointemail.model.SendEmailRequest.ReadOnly {
    override val fromEmailAddress: Option[EmailAddress] = scala
      .Option(impl.fromEmailAddress())
      .map(value => zio.aws.pinpointemail.model.primitives.EmailAddress(value))
    override val destination: zio.aws.pinpointemail.model.Destination.ReadOnly =
      zio.aws.pinpointemail.model.Destination.wrap(impl.destination())
    override val replyToAddresses: Option[List[EmailAddress]] = scala
      .Option(impl.replyToAddresses())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.pinpointemail.model.primitives.EmailAddress(item)
        }.toList
      )
    override val feedbackForwardingEmailAddress: Option[EmailAddress] = scala
      .Option(impl.feedbackForwardingEmailAddress())
      .map(value => zio.aws.pinpointemail.model.primitives.EmailAddress(value))
    override val content: zio.aws.pinpointemail.model.EmailContent.ReadOnly =
      zio.aws.pinpointemail.model.EmailContent.wrap(impl.content())
    override val emailTags
        : Option[List[zio.aws.pinpointemail.model.MessageTag.ReadOnly]] = scala
      .Option(impl.emailTags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.pinpointemail.model.MessageTag.wrap(item)
        }.toList
      )
    override val configurationSetName: Option[ConfigurationSetName] = scala
      .Option(impl.configurationSetName())
      .map(value =>
        zio.aws.pinpointemail.model.primitives.ConfigurationSetName(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpointemail.model.SendEmailRequest
  ): zio.aws.pinpointemail.model.SendEmailRequest.ReadOnly = new Wrapper(impl)
}
