package zio.aws.pinpointemail.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpointemail.model.primitives.{Timestamp, Domain}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class DomainDeliverabilityTrackingOption(
    domain: Option[Domain] = None,
    subscriptionStartDate: Option[Timestamp] = None,
    inboxPlacementTrackingOption: Option[
      zio.aws.pinpointemail.model.InboxPlacementTrackingOption
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpointemail.model.DomainDeliverabilityTrackingOption = {
    import DomainDeliverabilityTrackingOption.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpointemail.model.DomainDeliverabilityTrackingOption
      .builder()
      .optionallyWith(
        domain.map(value => Domain.unwrap(value): java.lang.String)
      )(_.domain)
      .optionallyWith(
        subscriptionStartDate.map(value => Timestamp.unwrap(value): Instant)
      )(_.subscriptionStartDate)
      .optionallyWith(
        inboxPlacementTrackingOption.map(value => value.buildAwsValue())
      )(_.inboxPlacementTrackingOption)
      .build()
  }
  def asReadOnly
      : zio.aws.pinpointemail.model.DomainDeliverabilityTrackingOption.ReadOnly =
    zio.aws.pinpointemail.model.DomainDeliverabilityTrackingOption
      .wrap(buildAwsValue())
}
object DomainDeliverabilityTrackingOption {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpointemail.model.DomainDeliverabilityTrackingOption
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.pinpointemail.model.DomainDeliverabilityTrackingOption =
      zio.aws.pinpointemail.model.DomainDeliverabilityTrackingOption(
        domain.map(value => value),
        subscriptionStartDate.map(value => value),
        inboxPlacementTrackingOption.map(value => value.asEditable)
      )
    def domain: Option[Domain]
    def subscriptionStartDate: Option[Timestamp]
    def inboxPlacementTrackingOption: Option[
      zio.aws.pinpointemail.model.InboxPlacementTrackingOption.ReadOnly
    ]
    def getDomain: ZIO[Any, AwsError, Domain] =
      AwsError.unwrapOptionField("domain", domain)
    def getSubscriptionStartDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("subscriptionStartDate", subscriptionStartDate)
    def getInboxPlacementTrackingOption: ZIO[
      Any,
      AwsError,
      zio.aws.pinpointemail.model.InboxPlacementTrackingOption.ReadOnly
    ] = AwsError.unwrapOptionField(
      "inboxPlacementTrackingOption",
      inboxPlacementTrackingOption
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpointemail.model.DomainDeliverabilityTrackingOption
  ) extends zio.aws.pinpointemail.model.DomainDeliverabilityTrackingOption.ReadOnly {
    override val domain: Option[Domain] = scala
      .Option(impl.domain())
      .map(value => zio.aws.pinpointemail.model.primitives.Domain(value))
    override val subscriptionStartDate: Option[Timestamp] = scala
      .Option(impl.subscriptionStartDate())
      .map(value => zio.aws.pinpointemail.model.primitives.Timestamp(value))
    override val inboxPlacementTrackingOption: Option[
      zio.aws.pinpointemail.model.InboxPlacementTrackingOption.ReadOnly
    ] = scala
      .Option(impl.inboxPlacementTrackingOption())
      .map(value =>
        zio.aws.pinpointemail.model.InboxPlacementTrackingOption.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpointemail.model.DomainDeliverabilityTrackingOption
  ): zio.aws.pinpointemail.model.DomainDeliverabilityTrackingOption.ReadOnly =
    new Wrapper(impl)
}
