package zio.aws.pinpointemail.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpointemail.model.primitives.PoolName
import scala.jdk.CollectionConverters._
final case class CreateDedicatedIpPoolRequest(
    poolName: PoolName,
    tags: Option[Iterable[zio.aws.pinpointemail.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpointemail.model.CreateDedicatedIpPoolRequest = {
    import CreateDedicatedIpPoolRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpointemail.model.CreateDedicatedIpPoolRequest
      .builder()
      .poolName(PoolName.unwrap(poolName): java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.pinpointemail.model.CreateDedicatedIpPoolRequest.ReadOnly =
    zio.aws.pinpointemail.model.CreateDedicatedIpPoolRequest
      .wrap(buildAwsValue())
}
object CreateDedicatedIpPoolRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpointemail.model.CreateDedicatedIpPoolRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpointemail.model.CreateDedicatedIpPoolRequest =
      zio.aws.pinpointemail.model.CreateDedicatedIpPoolRequest(
        poolName,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def poolName: PoolName
    def tags: Option[List[zio.aws.pinpointemail.model.Tag.ReadOnly]]
    def getPoolName: ZIO[Any, Nothing, PoolName] = ZIO.succeed(poolName)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.pinpointemail.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpointemail.model.CreateDedicatedIpPoolRequest
  ) extends zio.aws.pinpointemail.model.CreateDedicatedIpPoolRequest.ReadOnly {
    override val poolName: PoolName =
      zio.aws.pinpointemail.model.primitives.PoolName(impl.poolName())
    override val tags: Option[List[zio.aws.pinpointemail.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.pinpointemail.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpointemail.model.CreateDedicatedIpPoolRequest
  ): zio.aws.pinpointemail.model.CreateDedicatedIpPoolRequest.ReadOnly =
    new Wrapper(impl)
}
