package zio.aws.pinpointemail.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpointemail.model.primitives.{
  GeneralEnforcementStatus,
  Enabled
}
import scala.jdk.CollectionConverters._
final case class GetAccountResponse(
    sendQuota: Option[zio.aws.pinpointemail.model.SendQuota] = None,
    sendingEnabled: Option[Enabled] = None,
    dedicatedIpAutoWarmupEnabled: Option[Enabled] = None,
    enforcementStatus: Option[GeneralEnforcementStatus] = None,
    productionAccessEnabled: Option[Enabled] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpointemail.model.GetAccountResponse = {
    import GetAccountResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpointemail.model.GetAccountResponse
      .builder()
      .optionallyWith(sendQuota.map(value => value.buildAwsValue()))(
        _.sendQuota
      )
      .optionallyWith(
        sendingEnabled.map(value => Enabled.unwrap(value): java.lang.Boolean)
      )(_.sendingEnabled)
      .optionallyWith(
        dedicatedIpAutoWarmupEnabled.map(value =>
          Enabled.unwrap(value): java.lang.Boolean
        )
      )(_.dedicatedIpAutoWarmupEnabled)
      .optionallyWith(
        enforcementStatus.map(value =>
          GeneralEnforcementStatus.unwrap(value): java.lang.String
        )
      )(_.enforcementStatus)
      .optionallyWith(
        productionAccessEnabled.map(value =>
          Enabled.unwrap(value): java.lang.Boolean
        )
      )(_.productionAccessEnabled)
      .build()
  }
  def asReadOnly: zio.aws.pinpointemail.model.GetAccountResponse.ReadOnly =
    zio.aws.pinpointemail.model.GetAccountResponse.wrap(buildAwsValue())
}
object GetAccountResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpointemail.model.GetAccountResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpointemail.model.GetAccountResponse =
      zio.aws.pinpointemail.model.GetAccountResponse(
        sendQuota.map(value => value.asEditable),
        sendingEnabled.map(value => value),
        dedicatedIpAutoWarmupEnabled.map(value => value),
        enforcementStatus.map(value => value),
        productionAccessEnabled.map(value => value)
      )
    def sendQuota: Option[zio.aws.pinpointemail.model.SendQuota.ReadOnly]
    def sendingEnabled: Option[Enabled]
    def dedicatedIpAutoWarmupEnabled: Option[Enabled]
    def enforcementStatus: Option[GeneralEnforcementStatus]
    def productionAccessEnabled: Option[Enabled]
    def getSendQuota
        : ZIO[Any, AwsError, zio.aws.pinpointemail.model.SendQuota.ReadOnly] =
      AwsError.unwrapOptionField("sendQuota", sendQuota)
    def getSendingEnabled: ZIO[Any, AwsError, Enabled] =
      AwsError.unwrapOptionField("sendingEnabled", sendingEnabled)
    def getDedicatedIpAutoWarmupEnabled: ZIO[Any, AwsError, Enabled] =
      AwsError.unwrapOptionField(
        "dedicatedIpAutoWarmupEnabled",
        dedicatedIpAutoWarmupEnabled
      )
    def getEnforcementStatus: ZIO[Any, AwsError, GeneralEnforcementStatus] =
      AwsError.unwrapOptionField("enforcementStatus", enforcementStatus)
    def getProductionAccessEnabled: ZIO[Any, AwsError, Enabled] = AwsError
      .unwrapOptionField("productionAccessEnabled", productionAccessEnabled)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpointemail.model.GetAccountResponse
  ) extends zio.aws.pinpointemail.model.GetAccountResponse.ReadOnly {
    override val sendQuota
        : Option[zio.aws.pinpointemail.model.SendQuota.ReadOnly] = scala
      .Option(impl.sendQuota())
      .map(value => zio.aws.pinpointemail.model.SendQuota.wrap(value))
    override val sendingEnabled: Option[Enabled] = scala
      .Option(impl.sendingEnabled())
      .map(value => zio.aws.pinpointemail.model.primitives.Enabled(value))
    override val dedicatedIpAutoWarmupEnabled: Option[Enabled] = scala
      .Option(impl.dedicatedIpAutoWarmupEnabled())
      .map(value => zio.aws.pinpointemail.model.primitives.Enabled(value))
    override val enforcementStatus: Option[GeneralEnforcementStatus] = scala
      .Option(impl.enforcementStatus())
      .map(value =>
        zio.aws.pinpointemail.model.primitives.GeneralEnforcementStatus(value)
      )
    override val productionAccessEnabled: Option[Enabled] = scala
      .Option(impl.productionAccessEnabled())
      .map(value => zio.aws.pinpointemail.model.primitives.Enabled(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpointemail.model.GetAccountResponse
  ): zio.aws.pinpointemail.model.GetAccountResponse.ReadOnly = new Wrapper(impl)
}
